/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudsearch.AmazonCloudSearchAsync;
import com.amazonaws.services.cloudsearch.AmazonCloudSearchClient;
import com.amazonaws.services.cloudsearch.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearch.model.CreateDomainResult;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearch.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsResult;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudSearchAsyncClient
extends AmazonCloudSearchClient
implements AmazonCloudSearchAsync {
    private ExecutorService executorService;

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudSearchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudSearchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdateDefaultSearchFieldResult> updateDefaultSearchFieldAsync(final UpdateDefaultSearchFieldRequest updateDefaultSearchFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateDefaultSearchFieldResult>(){

            @Override
            public UpdateDefaultSearchFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateDefaultSearchField(updateDefaultSearchFieldRequest);
            }
        });
    }

    @Override
    public Future<DeleteRankExpressionResult> deleteRankExpressionAsync(final DeleteRankExpressionRequest deleteRankExpressionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteRankExpressionResult>(){

            @Override
            public DeleteRankExpressionResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteRankExpression(deleteRankExpressionRequest);
            }
        });
    }

    @Override
    public Future<DescribeRankExpressionsResult> describeRankExpressionsAsync(final DescribeRankExpressionsRequest describeRankExpressionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRankExpressionsResult>(){

            @Override
            public DescribeRankExpressionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeRankExpressions(describeRankExpressionsRequest);
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(final CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.createDomain(createDomainRequest);
            }
        });
    }

    @Override
    public Future<UpdateServiceAccessPoliciesResult> updateServiceAccessPoliciesAsync(final UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateServiceAccessPoliciesResult>(){

            @Override
            public UpdateServiceAccessPoliciesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateServiceAccessPolicies(updateServiceAccessPoliciesRequest);
            }
        });
    }

    @Override
    public Future<DefineIndexFieldResult> defineIndexFieldAsync(final DefineIndexFieldRequest defineIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineIndexFieldResult>(){

            @Override
            public DefineIndexFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineIndexField(defineIndexFieldRequest);
            }
        });
    }

    @Override
    public Future<DefineRankExpressionResult> defineRankExpressionAsync(final DefineRankExpressionRequest defineRankExpressionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DefineRankExpressionResult>(){

            @Override
            public DefineRankExpressionResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.defineRankExpression(defineRankExpressionRequest);
            }
        });
    }

    @Override
    public Future<DescribeSynonymOptionsResult> describeSynonymOptionsAsync(final DescribeSynonymOptionsRequest describeSynonymOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSynonymOptionsResult>(){

            @Override
            public DescribeSynonymOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeSynonymOptions(describeSynonymOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeStopwordOptionsResult> describeStopwordOptionsAsync(final DescribeStopwordOptionsRequest describeStopwordOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStopwordOptionsResult>(){

            @Override
            public DescribeStopwordOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeStopwordOptions(describeStopwordOptionsRequest);
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteDomain(deleteDomainRequest);
            }
        });
    }

    @Override
    public Future<DescribeServiceAccessPoliciesResult> describeServiceAccessPoliciesAsync(final DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeServiceAccessPoliciesResult>(){

            @Override
            public DescribeServiceAccessPoliciesResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeServiceAccessPolicies(describeServiceAccessPoliciesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDefaultSearchFieldResult> describeDefaultSearchFieldAsync(final DescribeDefaultSearchFieldRequest describeDefaultSearchFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDefaultSearchFieldResult>(){

            @Override
            public DescribeDefaultSearchFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeDefaultSearchField(describeDefaultSearchFieldRequest);
            }
        });
    }

    @Override
    public Future<UpdateStopwordOptionsResult> updateStopwordOptionsAsync(final UpdateStopwordOptionsRequest updateStopwordOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStopwordOptionsResult>(){

            @Override
            public UpdateStopwordOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateStopwordOptions(updateStopwordOptionsRequest);
            }
        });
    }

    @Override
    public Future<UpdateSynonymOptionsResult> updateSynonymOptionsAsync(final UpdateSynonymOptionsRequest updateSynonymOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateSynonymOptionsResult>(){

            @Override
            public UpdateSynonymOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateSynonymOptions(updateSynonymOptionsRequest);
            }
        });
    }

    @Override
    public Future<UpdateStemmingOptionsResult> updateStemmingOptionsAsync(final UpdateStemmingOptionsRequest updateStemmingOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStemmingOptionsResult>(){

            @Override
            public UpdateStemmingOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.updateStemmingOptions(updateStemmingOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeStemmingOptionsResult> describeStemmingOptionsAsync(final DescribeStemmingOptionsRequest describeStemmingOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStemmingOptionsResult>(){

            @Override
            public DescribeStemmingOptionsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeStemmingOptions(describeStemmingOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDomainsResult> describeDomainsAsync(final DescribeDomainsRequest describeDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDomainsResult>(){

            @Override
            public DescribeDomainsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeDomains(describeDomainsRequest);
            }
        });
    }

    @Override
    public Future<IndexDocumentsResult> indexDocumentsAsync(final IndexDocumentsRequest indexDocumentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<IndexDocumentsResult>(){

            @Override
            public IndexDocumentsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.indexDocuments(indexDocumentsRequest);
            }
        });
    }

    @Override
    public Future<DescribeIndexFieldsResult> describeIndexFieldsAsync(final DescribeIndexFieldsRequest describeIndexFieldsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIndexFieldsResult>(){

            @Override
            public DescribeIndexFieldsResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.describeIndexFields(describeIndexFieldsRequest);
            }
        });
    }

    @Override
    public Future<DeleteIndexFieldResult> deleteIndexFieldAsync(final DeleteIndexFieldRequest deleteIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteIndexFieldResult>(){

            @Override
            public DeleteIndexFieldResult call() throws Exception {
                return AmazonCloudSearchAsyncClient.this.deleteIndexField(deleteIndexFieldRequest);
            }
        });
    }
}

