/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatch.model.StateValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeAlarmsRequest
extends AmazonWebServiceRequest {
    private List<String> alarmNames;
    private String alarmNamePrefix;
    private String stateValue;
    private String actionPrefix;
    private Integer maxRecords;
    private String nextToken;

    public List<String> getAlarmNames() {
        if (this.alarmNames == null) {
            this.alarmNames = new ArrayList<String>();
        }
        return this.alarmNames;
    }

    public void setAlarmNames(Collection<String> alarmNames) {
        if (alarmNames == null) {
            this.alarmNames = null;
            return;
        }
        ArrayList<String> alarmNamesCopy = new ArrayList<String>(alarmNames.size());
        alarmNamesCopy.addAll(alarmNames);
        this.alarmNames = alarmNamesCopy;
    }

    public DescribeAlarmsRequest withAlarmNames(String ... alarmNames) {
        if (this.getAlarmNames() == null) {
            this.setAlarmNames(new ArrayList<String>(alarmNames.length));
        }
        for (String value : alarmNames) {
            this.getAlarmNames().add(value);
        }
        return this;
    }

    public DescribeAlarmsRequest withAlarmNames(Collection<String> alarmNames) {
        if (alarmNames == null) {
            this.alarmNames = null;
        } else {
            ArrayList<String> alarmNamesCopy = new ArrayList<String>(alarmNames.size());
            alarmNamesCopy.addAll(alarmNames);
            this.alarmNames = alarmNamesCopy;
        }
        return this;
    }

    public String getAlarmNamePrefix() {
        return this.alarmNamePrefix;
    }

    public void setAlarmNamePrefix(String alarmNamePrefix) {
        this.alarmNamePrefix = alarmNamePrefix;
    }

    public DescribeAlarmsRequest withAlarmNamePrefix(String alarmNamePrefix) {
        this.alarmNamePrefix = alarmNamePrefix;
        return this;
    }

    public String getStateValue() {
        return this.stateValue;
    }

    public void setStateValue(String stateValue) {
        this.stateValue = stateValue;
    }

    public DescribeAlarmsRequest withStateValue(String stateValue) {
        this.stateValue = stateValue;
        return this;
    }

    public void setStateValue(StateValue stateValue) {
        this.stateValue = stateValue.toString();
    }

    public DescribeAlarmsRequest withStateValue(StateValue stateValue) {
        this.stateValue = stateValue.toString();
        return this;
    }

    public String getActionPrefix() {
        return this.actionPrefix;
    }

    public void setActionPrefix(String actionPrefix) {
        this.actionPrefix = actionPrefix;
    }

    public DescribeAlarmsRequest withActionPrefix(String actionPrefix) {
        this.actionPrefix = actionPrefix;
        return this;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public DescribeAlarmsRequest withMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeAlarmsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alarmNames != null) {
            sb.append("AlarmNames: " + this.alarmNames + ", ");
        }
        if (this.alarmNamePrefix != null) {
            sb.append("AlarmNamePrefix: " + this.alarmNamePrefix + ", ");
        }
        if (this.stateValue != null) {
            sb.append("StateValue: " + this.stateValue + ", ");
        }
        if (this.actionPrefix != null) {
            sb.append("ActionPrefix: " + this.actionPrefix + ", ");
        }
        if (this.maxRecords != null) {
            sb.append("MaxRecords: " + this.maxRecords + ", ");
        }
        if (this.nextToken != null) {
            sb.append("NextToken: " + this.nextToken + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlarmNames() == null ? 0 : ((Object)this.getAlarmNames()).hashCode());
        hashCode = 31 * hashCode + (this.getAlarmNamePrefix() == null ? 0 : this.getAlarmNamePrefix().hashCode());
        hashCode = 31 * hashCode + (this.getStateValue() == null ? 0 : this.getStateValue().hashCode());
        hashCode = 31 * hashCode + (this.getActionPrefix() == null ? 0 : this.getActionPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsRequest)) {
            return false;
        }
        DescribeAlarmsRequest other = (DescribeAlarmsRequest)obj;
        if (other.getAlarmNames() == null ^ this.getAlarmNames() == null) {
            return false;
        }
        if (other.getAlarmNames() != null && !((Object)other.getAlarmNames()).equals(this.getAlarmNames())) {
            return false;
        }
        if (other.getAlarmNamePrefix() == null ^ this.getAlarmNamePrefix() == null) {
            return false;
        }
        if (other.getAlarmNamePrefix() != null && !other.getAlarmNamePrefix().equals(this.getAlarmNamePrefix())) {
            return false;
        }
        if (other.getStateValue() == null ^ this.getStateValue() == null) {
            return false;
        }
        if (other.getStateValue() != null && !other.getStateValue().equals(this.getStateValue())) {
            return false;
        }
        if (other.getActionPrefix() == null ^ this.getActionPrefix() == null) {
            return false;
        }
        if (other.getActionPrefix() != null && !other.getActionPrefix().equals(this.getActionPrefix())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

