/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.services.simpleworkflow.model.CloseStatus;
import com.amazonaws.services.simpleworkflow.model.ExecutionStatus;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowExecutionInfo {
    private WorkflowExecution execution;
    private WorkflowType workflowType;
    private Date startTimestamp;
    private Date closeTimestamp;
    private String executionStatus;
    private String closeStatus;
    private WorkflowExecution parent;
    private List<String> tagList;
    private Boolean cancelRequested;

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public void setExecution(WorkflowExecution execution) {
        this.execution = execution;
    }

    public WorkflowExecutionInfo withExecution(WorkflowExecution execution) {
        this.execution = execution;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public WorkflowExecutionInfo withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public WorkflowExecutionInfo withStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
        return this;
    }

    public Date getCloseTimestamp() {
        return this.closeTimestamp;
    }

    public void setCloseTimestamp(Date closeTimestamp) {
        this.closeTimestamp = closeTimestamp;
    }

    public WorkflowExecutionInfo withCloseTimestamp(Date closeTimestamp) {
        this.closeTimestamp = closeTimestamp;
        return this;
    }

    public String getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(String executionStatus) {
        this.executionStatus = executionStatus;
    }

    public WorkflowExecutionInfo withExecutionStatus(String executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus.toString();
    }

    public WorkflowExecutionInfo withExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus.toString();
        return this;
    }

    public String getCloseStatus() {
        return this.closeStatus;
    }

    public void setCloseStatus(String closeStatus) {
        this.closeStatus = closeStatus;
    }

    public WorkflowExecutionInfo withCloseStatus(String closeStatus) {
        this.closeStatus = closeStatus;
        return this;
    }

    public void setCloseStatus(CloseStatus closeStatus) {
        this.closeStatus = closeStatus.toString();
    }

    public WorkflowExecutionInfo withCloseStatus(CloseStatus closeStatus) {
        this.closeStatus = closeStatus.toString();
        return this;
    }

    public WorkflowExecution getParent() {
        return this.parent;
    }

    public void setParent(WorkflowExecution parent) {
        this.parent = parent;
    }

    public WorkflowExecutionInfo withParent(WorkflowExecution parent) {
        this.parent = parent;
        return this;
    }

    public List<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new ArrayList<String>();
        }
        return this.tagList;
    }

    public void setTagList(Collection<String> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        ArrayList<String> tagListCopy = new ArrayList<String>(tagList.size());
        tagListCopy.addAll(tagList);
        this.tagList = tagListCopy;
    }

    public WorkflowExecutionInfo withTagList(String ... tagList) {
        if (this.getTagList() == null) {
            this.setTagList(new ArrayList<String>(tagList.length));
        }
        for (String value : tagList) {
            this.getTagList().add(value);
        }
        return this;
    }

    public WorkflowExecutionInfo withTagList(Collection<String> tagList) {
        if (tagList == null) {
            this.tagList = null;
        } else {
            ArrayList<String> tagListCopy = new ArrayList<String>(tagList.size());
            tagListCopy.addAll(tagList);
            this.tagList = tagListCopy;
        }
        return this;
    }

    public Boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public void setCancelRequested(Boolean cancelRequested) {
        this.cancelRequested = cancelRequested;
    }

    public WorkflowExecutionInfo withCancelRequested(Boolean cancelRequested) {
        this.cancelRequested = cancelRequested;
        return this;
    }

    public Boolean getCancelRequested() {
        return this.cancelRequested;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.execution != null) {
            sb.append("Execution: " + this.execution + ", ");
        }
        if (this.workflowType != null) {
            sb.append("WorkflowType: " + this.workflowType + ", ");
        }
        if (this.startTimestamp != null) {
            sb.append("StartTimestamp: " + this.startTimestamp + ", ");
        }
        if (this.closeTimestamp != null) {
            sb.append("CloseTimestamp: " + this.closeTimestamp + ", ");
        }
        if (this.executionStatus != null) {
            sb.append("ExecutionStatus: " + this.executionStatus + ", ");
        }
        if (this.closeStatus != null) {
            sb.append("CloseStatus: " + this.closeStatus + ", ");
        }
        if (this.parent != null) {
            sb.append("Parent: " + this.parent + ", ");
        }
        if (this.tagList != null) {
            sb.append("TagList: " + this.tagList + ", ");
        }
        if (this.cancelRequested != null) {
            sb.append("CancelRequested: " + this.cancelRequested + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecution() == null ? 0 : this.getExecution().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowType() == null ? 0 : this.getWorkflowType().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getCloseTimestamp() == null ? 0 : this.getCloseTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStatus() == null ? 0 : this.getExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCloseStatus() == null ? 0 : this.getCloseStatus().hashCode());
        hashCode = 31 * hashCode + (this.getParent() == null ? 0 : this.getParent().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : ((Object)this.getTagList()).hashCode());
        hashCode = 31 * hashCode + (this.isCancelRequested() == null ? 0 : this.isCancelRequested().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo)obj;
        if (other.getExecution() == null ^ this.getExecution() == null) {
            return false;
        }
        if (other.getExecution() != null && !other.getExecution().equals(this.getExecution())) {
            return false;
        }
        if (other.getWorkflowType() == null ^ this.getWorkflowType() == null) {
            return false;
        }
        if (other.getWorkflowType() != null && !other.getWorkflowType().equals(this.getWorkflowType())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        if (other.getStartTimestamp() != null && !other.getStartTimestamp().equals(this.getStartTimestamp())) {
            return false;
        }
        if (other.getCloseTimestamp() == null ^ this.getCloseTimestamp() == null) {
            return false;
        }
        if (other.getCloseTimestamp() != null && !other.getCloseTimestamp().equals(this.getCloseTimestamp())) {
            return false;
        }
        if (other.getExecutionStatus() == null ^ this.getExecutionStatus() == null) {
            return false;
        }
        if (other.getExecutionStatus() != null && !other.getExecutionStatus().equals(this.getExecutionStatus())) {
            return false;
        }
        if (other.getCloseStatus() == null ^ this.getCloseStatus() == null) {
            return false;
        }
        if (other.getCloseStatus() != null && !other.getCloseStatus().equals(this.getCloseStatus())) {
            return false;
        }
        if (other.getParent() == null ^ this.getParent() == null) {
            return false;
        }
        if (other.getParent() != null && !other.getParent().equals(this.getParent())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        if (other.getTagList() != null && !((Object)other.getTagList()).equals(this.getTagList())) {
            return false;
        }
        if (other.isCancelRequested() == null ^ this.isCancelRequested() == null) {
            return false;
        }
        return other.isCancelRequested() == null || other.isCancelRequested().equals(this.isCancelRequested());
    }
}

