% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_transfer.R
\name{cloud_s3_upload}
\alias{cloud_s3_upload}
\title{Upload a local file to S3}
\usage{
cloud_s3_upload(file, root = NULL)
}
\arguments{
\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{root}{S3 path of the project root. This serves as the reference point
for all relative paths. When left as \code{NULL}, the root is automatically
derived from the \code{cloudfs.s3} field of the project's DESCRIPTION file.}
}
\value{
Invisibly returns \code{NULL} after successfully uploading the file.
}
\description{
Uploads a local file from the project's directory to its
corresponding location within the project's S3 root folder.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a toy csv file
dir.create("toy_data")
write.csv(mtcars, "toy_data/mtcars.csv")

# uploads toy_data/mtcars.csv to 'data' subfolder of project's S3 folder
cloud_s3_upload("toy_data/mtcars.csv")

# clean up
unlink("toy_data", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
