% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{angle_deltas}
\alias{angle_deltas}
\title{Get angles between average cluster direction and cluster-supporting lines}
\usage{
angle_deltas(num_clusters, angle_disp)
}
\arguments{
\item{num_clusters}{Number of clusters.}

\item{angle_disp}{Angle dispersion, in radians.}
}
\value{
Angles between the average cluster direction and the
cluster-supporting lines, given in radians in the interval
\mjeqn{\left[-\pi/2,\pi/2\right]}{[-π/2, π/2]}
}
\description{
\loadmathjax
Determine the angles between the average cluster direction and the
cluster-supporting lines. These angles are obtained from a wrapped normal
distribution (\mjeqn{\mu=0}{μ=0}, \mjeqn{\sigma=}{σ=} \code{angle_disp} ) with
support in the interval \mjeqn{\left[-\pi/2,\pi/2\right]}{[-π/2, π/2]}.
Note this is different from the standard wrapped normal distribution, the
support of which is given by the interval
\mjeqn{\left[-\pi,\pi\right]}{[-π, π]}.
}
\note{
This function is stochastic. For reproducibility set a PRNG seed with
\link{set.seed}.
}
\examples{
set.seed(123)
arad <- angle_deltas(4, pi / 8) # Angle dispersion of 22.5 degrees
arad                            # What angles deltas did we get?
arad * 180 / pi                 #  Show angle deltas in degrees
}
