% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDoseResponseData.R
\name{plotDoseResponseData}
\alias{plotDoseResponseData}
\title{plot dose-response curves}
\usage{
plotDoseResponseData(inputDataset, dose, response, ID, subjectID,
  xlab = "Dose", ylab = "Response", addMean = TRUE,
  drcPattern = NULL)
}
\arguments{
\item{inputDataset}{a data frame containing the input dataset, it should at least include dose, response, and ID}

\item{dose}{either a single string or a scalar, indicating the name of the dose column or its index.}

\item{response}{either a single string or a scalar, indicating the name of the response column or its index.}

\item{ID}{either a single string or a scalar, indicating the name of the ID column or its index.}

\item{subjectID}{single input as the same type as given ID column with the ID of the subject to plot.}

\item{xlab}{single string with default "dose", the label on x axis.}

\item{ylab}{single string with default "response", the label on y axis.}

\item{addMean}{logical variable indicating whether mean values (connecting with lines) should be plotted or not.}

\item{drcPattern}{single string showing the idetified pattern using clustering algorithms. The default is NULL. In such case, no extra 
line will be added to the plot regarding the estimated means via the identified pattern.}
}
\value{
make a plot.
}
\description{
function to plot dose-response curves with the possibility of adding lines indicating average response per dose levels. Also, 
provided a pattern for the dose-response curve, it can estimate the expected mean values per dose level for the given pattern and
add them to the plot.
}
\details{
with addMean = TRUE, a line will be added to the plot, connecting the averaged response per dose level. 
But when a pattern is provided for the dose-response curve via drcPattern, then a line will be added to the data with the means 
estimated assuming the identified pattern. If both addMEan = TRUE and drcPattern != NULL, then two lines will be added to the plot. The line in 
purplish-colored with cross signs as points is the averaged response value per dose level, and the bluish-colored line with circled cross signs as points
represents the estimated mean based on the pattern.
}
\examples{
## gnerating data, a sample of size 20
set.seed(11)
doses2Use <-  c(0, 5, 20)
numRep2Use <- c(3, 3, 3)
generatedData <- cbind(rep(1,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), doses2Use, 
numRep2Use, 1), 
		matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(generatedData) <- c("ID", "dose", "response", "x1")
for (iGen in 2:15){
genData0 <- cbind(rep(iGen,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), 
doses2Use, numRep2Use, 1), 
			matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(genData0) <- c("ID", "dose", "response", "x1")
generatedData <- rbind(generatedData, genData0)
}
## plotting dose response relation
plotDoseResponseData(generatedData, 2, 3, 1, 2)
## transforming it for clustering
plotDoseResponseData(generatedData, 2, 3, 1, 2, 
addMean = FALSE, 
		drcPattern = "increasing")

}
\author{
Vahid Nassiri and Yimer Wasihun.
}
