% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustMD_InternalFunctions.R
\name{M.step}
\alias{M.step}
\title{M-step of the (MC)EM algorithm}
\usage{
M.step(tau, N, sumTauEz, J, OrdIndx, D, G, Y, CnsIndx, sumTauS, model, a,
  nom.ind.Z)
}
\arguments{
\item{tau}{a \code{N x G} matrix of cluster membership probabilities.}

\item{N}{number of observations.}

\item{sumTauEz}{the sum across all observations of observed and expected 
latent continuous values mutiplied by the posterior probability of 
belonging to each cluster.}

\item{J}{the number of variables.}

\item{OrdIndx}{the sum of the number of continuous and ordinal (including
binary) variables.}

\item{D}{dimension of the latent data.}

\item{G}{the number of mixture components.}

\item{Y}{a \code{N x J} data matrix.}

\item{CnsIndx}{the number of continuous variables.}

\item{sumTauS}{the sum across all observations of outer product of observed
and expected latent continuous values mutiplied by the posterior 
probability of belonging to each cluster.}

\item{model}{which \code{clustMD} covariance model is fitted.}

\item{a}{a \code{G x D} matrix of the entries of A.}

\item{nom.ind.Z}{the latent dimensions corresponding to each nominal variable.}
}
\value{
Output required for \code{clustMD} function.
}
\description{
Internal function.
}
\seealso{
\code{\link{clustMD}}
}
\keyword{internal}

