% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kprototypes.R
\name{lambdaest}
\alias{lambdaest}
\title{compares variance of all variables}
\usage{
lambdaest(x)
}
\arguments{
\item{x}{Original data.}
}
\value{
\item{lambda}{Ratio of averages over all numeric/factor variables is returned.}
}
\description{
Investigation of variances to specify lambda for k prototypes clustering .
}
\details{
Variance of numeric variables and \eqn{1-\sum_i p_i^2} of categorical variance is computed.
}
\examples{
# generate toy data with factors and numerics

n   <- 100
prb <- 0.9
muk <- 1.5 
clusid <- rep(1:4, each = n)

x1 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x1 <- c(x1, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x1 <- as.factor(x1)

x2 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x2 <- c(x2, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x2 <- as.factor(x2)

x3 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))
x4 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))

x <- data.frame(x1,x2,x3,x4)

a <- lambdaest(x)
res <- kproto(x, 2, lambda = a)

}
\author{
\email{gero.szepannek@web.de}
}

