% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterfns.R
\name{get_clusters}
\alias{get_clusters}
\title{get_clusters}
\usage{
get_clusters(
  myData,
  k_clust = 3,
  n_bg = 0,
  quick = TRUE,
  EMseeds = 1,
  edgepmat = NULL,
  blacklist = NULL,
  bdepar = list(chi = 0.5, edgepf = 8),
  newallrelativeprobabs = NULL
)
}
\arguments{
\item{myData}{Data to be clustered, must be either binary (with levels "0"/"1") or categorical (with levels "0"/"1"/"2"/...)}

\item{k_clust}{Number of clusters}

\item{n_bg}{Number of covariates to be adjusted for; the position of the covariates must be in the last column of the myData matrix}

\item{quick}{if TRUE, then the runtime is quick but accuracy is lower}

\item{EMseeds}{Seeds}

\item{edgepmat}{Matrix of penalized edges in the search space}

\item{blacklist}{Matrix of forbidden edges in the search space}

\item{bdepar}{Hyperparameters for structure learning (BDE score)}

\item{newallrelativeprobabs}{relative probability of cluster assignment of each sample}
}
\value{
a list containing the clusterMemberships and "assignprogress"
}
\description{
Network-based clustering
}
\examples{
\donttest{
# choose data
sampled_data <- sampleData(n_vars = 15, n_samples = c(300,300,300))$sampled_data
# learn clusters
cluster_results <- get_clusters(sampled_data)
# visualize the networks
library(ggplot2)
library(ggraph)
library(igraph)
library(ggpubr)
plot_clusters(cluster_results)
}
}
