% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_new.R
\name{predict_new}
\alias{predict_new}
\alias{predict_new.CMF}
\alias{predict_new.CMF_implicit}
\alias{predict_new.OMF_explicit}
\alias{predict_new.OMF_implicit}
\alias{predict_new.ContentBased}
\title{Predict entries in new `X` data}
\usage{
predict_new(model, ...)

\method{predict_new}{CMF}(
  model,
  items,
  rows = NULL,
  X = NULL,
  U = NULL,
  U_bin = NULL,
  weight = NULL,
  ...
)

\method{predict_new}{CMF_implicit}(model, items, rows = NULL, X = NULL, U = NULL, ...)

\method{predict_new}{OMF_explicit}(
  model,
  items,
  rows = NULL,
  X = NULL,
  U = NULL,
  weight = NULL,
  exact = FALSE,
  ...
)

\method{predict_new}{OMF_implicit}(model, items, rows = NULL, X = NULL, U = NULL, ...)

\method{predict_new}{ContentBased}(model, items = NULL, rows = NULL, U = NULL, I = NULL, ...)
}
\arguments{
\item{model}{A collective matrix factorization model from this package - see
\link{fit_models} for details.}

\item{...}{Not used.}

\item{items}{The item IDs for which to make predictions. If `X` to which the model
was fit was a `data.frame`, should pass IDs matching to the second column of `X`
(the item indices, should be a character vector),
otherwise should pass column numbers for `X`, with numeration
starting at 1 (should be an integer vector).

If passing `I`, will instead take these indices as row numbers for `I`
(only available for the \link{ContentBased} model).}

\item{rows}{Rows of the new `X`/`U` passed here for which to make
predictions, with numeration starting at 1 (should be an integer vector).
If not passed and there is only 1 row of data, will predict the entries in
`items` for that same row. If not passed and there is more than 1 row of data,
the number of rows in the data should match with the number of entries in `items`,
and will make predictions for each such combination of <entry in item, row in the data>.}

\item{X}{New `X` data, with rows denoting new users.
Can be passed in the following formats:\itemize{
\item A sparse COO/triplets matrix, either from package
`Matrix` (class `dgTMatrix`), or from package `SparseM` (class `matrix.coo`).
\item A sparse matrix in CSR format, either from package
`Matrix` (class `dgRMatrix`), or from package `SparseM` (class `matrix.csr`).
Passing the input as CSR is faster than COO as it will be converted internally.
\item A sparse row vector from package `Matrix` (class `dsparseVector`).
\item A dense matrix from base R (class `matrix`), with missing entries set as `NA`/`NaN`.
\item A dense row vector from base R (class `numeric`), with missing entries set as `NA`/`NaN`.
}
Dense `X` data is not supported for `CMF_implicit` or `OMF_implicit`.}

\item{U}{New `U` data, with rows denoting new users.
Can be passed in the same formats as `X`, or additionally
as a `data.frame`, which will be internally converted to a matrix.}

\item{U_bin}{New binary columns of `U`. Must be passed as a dense matrix from
base R or as a `data.frame`.}

\item{weight}{Associated observation weights for entries in `X`. If passed, must
have the same shape as `X` - that is, if `X` is a sparse matrix, should be a
numeric vector with length equal to the non-missing elements, if `X` is a dense
matrix, should also be a dense matrix with the same number of rows and columns.}

\item{exact}{(In the `OMF_explicit` model)
Whether to calculate `A` and `Am` with the regularization applied
to `A` instead of to `Am` (if using the L-BFGS method, this is how the model
was fit). This is usually a slower procedure.}

\item{I}{(For the `ContentBased` model only) New `I` data for which to make predictions.
Supports the same formats as `U`.}
}
\value{
A numeric vector with the predicted values for the requested combinations
of users (rows in the new data) and items (columns in the old data, unless passing
`I` in which case will be rows of `I`). Invalid combinations will be filled with NAs.
}
\description{
Predict entries in columns of the `X` matrix for new users/rows
given their new `X` and/or `U` data at the combinations [row,column] given by the entries in
`user` and `item` (e.g. passing `user=c(1,2,3), item=c(1,1,1)` will predict
X[1,1], X[2,1], X[3,1]).

Note: this function will not perform any internal re-indexing for the data.
If the `X` to which the data was fit was a `data.frame`, the numeration of the
items will be under `model$info$item_mapping`.
}
\seealso{
\link{predict.cmfrec}
}
