% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat.R
\name{heat}
\alias{heat}
\title{Heat Equation via Forward-Time Central-Space}
\usage{
heat(u, alpha, xdelta, tdelta, n)
}
\arguments{
\item{u}{the initial values of u}

\item{alpha}{the thermal diffusivity coefficient}

\item{xdelta}{the change in \code{x} at each step in \code{u}}

\item{tdelta}{the time step}

\item{n}{the number of steps to take}
}
\value{
a matrix of u values at each time step
}
\description{
solve heat equation via forward-time central-space method
}
\details{
The \code{heat} solves the heat equation using the forward-time
central-space method in one-dimension.
}
\examples{
alpha <- 1
x0 <- 0
xdelta <- .05
x <- seq(x0, 1, xdelta)
u <- sin(x^4 * pi)
tdelta <- .001
n <- 25
z <- heat(u, alpha, xdelta, tdelta, n)

}

