% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_plot.R
\name{render_plot}
\alias{render_plot}
\title{Plotting routine designed for the CM SAF R Toolbox.}
\usage{
render_plot(
  plot_rinstat,
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  visualizeDataTimestep,
  nc_path_visualize,
  visualizeDataMax,
  lon_bounds,
  lat_bounds,
  lon_loc_vec,
  lat_loc_vec,
  name_loc_vec,
  timestep,
  num_tick,
  num_rmin,
  num_rmax,
  num_brk,
  co.data,
  co.data.compare.diff,
  proj,
  xort,
  yort,
  rort,
  slider1,
  slider2,
  imagewidth,
  imageheight,
  location,
  int,
  text1,
  text2,
  text3,
  textsize,
  bordercolor,
  linesize,
  na.color,
  PAL,
  palettes,
  reverse,
  plot_grid,
  grid_col
)
}
\arguments{
\item{plot_rinstat}{Whether to create an R-Instat plot (logical).}

\item{outfile}{Name of the outfile (NULL or character). Should match the fileExtension.
If NULL is passed a file is created in the R session temporary directory.}

\item{fileExtension}{The file extension of the image (character). Has to be one of the following: 'png', 'jpg', 'tif', 'kml', 'pdf'.}

\item{visualizeVariables}{A data frame containing all meta data for the plotting process (data.frame).}

\item{visualizeDataTimestep}{The data to be plotted.}

\item{nc_path_visualize}{The nc file path of which the plot is generated for.}

\item{visualizeDataMax}{Maximal data for computing breaks.}

\item{lon_bounds}{Array containing two values for longitude min and max (numeric).}

\item{lat_bounds}{Array containing two values for latitude min and max (numeric).}

\item{lon_loc_vec}{All longitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{lat_loc_vec}{All latitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{name_loc_vec}{Names for the points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{timestep}{The current timestep chosen.}

\item{num_tick}{Number of ticks (numeric).}

\item{num_rmin}{Color scale range minimum (numeric).}

\item{num_rmax}{Color scale range maximium (numeric).}

\item{num_brk}{Number of breaks (numeric).}

\item{co.data}{Data to be plotted in R-Instat mode (data.frame).}

\item{co.data.compare.diff}{Data to be plotted in compare data mode (data.frame).}

\item{proj}{The chosen projection (either 'rect' for rectangular or 'ortho' for orthographic).}

\item{xort}{Centering the globe at longitude xort (numeric). Only in orthographic mode.}

\item{yort}{Centering the globe at latitude yort (numeric). Only in orthographic mode.}

\item{rort}{Rotation of the globe (numeric). Only in orthographic mode.}

\item{slider1}{Controlling the horizontal plot position as vector of two values min and max (numeric).}

\item{slider2}{Controlling the vertical plot position as vector of two values min and max (numeric).}

\item{imagewidth}{Width of the image (numeric).}

\item{imageheight}{Height of the image (numeric).}

\item{location}{Whether points specified by (lat_loc_vec, lon_loc_vec, name_loc_vec) should be added to the map (logical).}

\item{int}{Whether interior country borders should be added (logical).}

\item{text1}{Title text (character).}

\item{text2}{Text to be passed to graphics::mtext (character).}

\item{text3}{Text to be added to the legend (character).}

\item{textsize}{Textsize to be used (cex).}

\item{bordercolor}{Color used for borders.}

\item{linesize}{Line width to be used (positive numeric).}

\item{na.color}{The color to be used for NA values.}

\item{PAL}{Color palette.}

\item{palettes}{Color palettes to be used.}

\item{reverse}{Whether to revert the color palette (logical).}

\item{plot_grid}{Whether to plot a grid using color grid_col (logical).}

\item{grid_col}{Color used for the grid.}
}
\description{
This function renders a 2D image usually called by the CM SAF R Toolbox.
}
