\name{some}
\alias{some}
\alias{some.data.frame}
\alias{some.configTable}

\title{
Randomly select configurations from a data frame or \code{configTable}
}

\description{
Randomly select configurations from a data frame or \code{configTable} with or without replacement.
}

\usage{
some(x, ...)

\method{some}{data.frame}(x, n = 10, replace = TRUE, ...)
\method{some}{configTable}(x, n = 10, replace = TRUE, ...)
}

\arguments{
  \item{x}{Data frame or \code{configTable}.}
  \item{n}{Sample size.}
  \item{replace}{Logical; if \code{TRUE}, configurations are sampled with replacement.}
  \item{\dots}{Not used.}
}

\details{The function \code{some} randomly samples configurations from \code{x}, which is a data frame or \code{configTable}. Such samples can, for instance, be used to simulate data fragmentation (limited diversity), i.e. the failure to observe/measure all configurations that are compatible with a data generating causal structure. They can also be used to simulate large-N data featuring multiple cases instantiating each configuration.
}

\value{
A data frame or configTable.
}

\note{
The generic function \code{some} is read from the package \pkg{car}.
The method for \code{data.frame}s in the \pkg{cna} package has an additional parameter \code{replace}, which is \code{TRUE} by default. It will thus not apply the same sampling scheme as the method in \pkg{car} by default.
}


\references{
Krook, Mona Lena. 2010.
\dQuote{Women's Representation in Parliament: A Qualitative Comparative Analysis.}
\emph{Political Studies} 58(5):886-908.

}


\seealso{\code{\link{configTable}}, \code{\link{selectCases}}, \code{\link{allCombs}}, \code{\link{makeFuzzy}}, \code{\link{cna}}, \code{\link{d.women}}
}

\examples{
# Randomly sample configurations from the dataset analyzed by Krook (2010).
ct.women <- configTable(d.women)
some(ct.women, 20)
some(ct.women, 5, replace = FALSE)
some(ct.women, 5, replace = TRUE)

# Simulate limited diversity in data generated by the causal structure 
# A=2*B=1 + C=3*D=4 <-> E=3.
dat1 <- allCombs(c(3, 3, 4, 4, 3))
dat2 <- selectCases("A=2*B=1 + C=3*D=4 <-> E=3", dat1, type = "mv")
(dat3 <- some(dat2, 150, replace = TRUE))
\donttest{mvcna(dat3)}

# Simulate large-N fuzzy-set data generated by the common-cause structure
# (A*b*C + B*c <-> D) * (A*B + a*C <-> E).
dat1 <- selectCases("(A*b*C + B*c <-> D) * (A*B + a*C <-> E)")
dat2 <- some(dat1, 250, replace = TRUE)
dat3 <- makeFuzzy(ct2df(dat2), fuzzvalues = seq(0, 0.45, 0.01))
fscna(dat3, ordering = list(c("D", "E")), strict = TRUE, con = .8, cov = .8)
}