% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{dist}
\alias{dist}
\title{Distance Matrix Computation (including Aitchison distance)}
\usage{
dist(x, method = "euclidean", ...)
}
\arguments{
\item{x}{compositions
method}

\item{method}{the distance measure to be used. This must be one of "aitchison", "euclidean", "maximum",
"manhattan", "canberra", "binary" or "minkowski". Any unambiguous substring can be given.}

\item{...}{arguments passed to \code{\link[stats]{dist}} function}
}
\value{
\code{dist} returns an object of class "dist".
}
\description{
This function overwrite \code{\link[stats]{dist}} function to contain Aitchison distance between
compositions.
}
\examples{
X = exp(matrix(rnorm(10*50), ncol=50, nrow=10))

(d <- dist(X, method = 'aitchison'))
plot(hclust(d))

# In contrast to Euclidean distance
dist(rbind(c(1,1,1), c(100, 100, 100)), method = 'euc') # method = 'euclidean'
# using Aitchison distance, only relative information is of importance
dist(rbind(c(1,1,1), c(100, 100, 100)), method = 'ait') # method = 'aitchison'

}
\seealso{
See functions \code{\link[stats]{dist}}.
}
