% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char2seed.R
\name{char2seed}
\alias{char2seed}
\title{Convert a character vector to a numeric integer for setting a reproducible seed}
\usage{
char2seed(x)
}
\arguments{
\item{x}{a character vector}
}
\value{
\code{char2seed()} takes a character vector and returns a reproducible seed for you to use for whatever purpose. It's used internally in
\code{codename()}.
}
\description{
\code{char2seed()} is a parlor trick for converting a character vector into an integer for the sake of setting a reproducible seed.
}
\details{
Interested users can see how this works. Namely, letters (and numbers) in the character vector are assigned corresponding numbers. These
numbers are added together and then exponentiated to create a really big number. The number is divided over 1 minus the absolute maximum number
that R can handle by default (2^32). The remainder of this division is what ultimately becomes the reproducible seed. The nature of this parlor trick means
there's a possibility, however infinitesimally small, that two different character vectors can return the same reproducible seed. The function may warn
of "loss of accuracy", but this just means you supplied it a really long character vector.
}
\examples{

char2seed("ABCDEF")
char2seed("Go Bucks!")
char2seed("My Project Title")

}
\author{
Steven V. Miller
}
