% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenmap-class.R
\docType{class}
\name{eigenmap-class}
\alias{eigenmap-class}
\alias{print.eigenmap}
\alias{plot.eigenmap}
\title{Class and Methods for Spatial Eigenvector Maps}
\format{
`eigenmap-class` objects contain:
\describe{
  \item{coordinates}{ A matrix of coordinates. }
  \item{truncate}{ The interval within which pairs of sites are considered as
  neighbours. }
  \item{D}{ A distance matrix. }
  \item{weighting}{ The weighting function that had been used. }
  \item{wpar}{ The weighting function parameter that had been used. }
  \item{lambda}{ A vector of the eigenvalues obtain from the computation
  of the eigenvector map. }
  \item{U}{ A matrix of the eigenvectors defining the eigenvector map. }
}
}
\usage{
\method{print}{eigenmap}(x, ...)

\method{plot}{eigenmap}(x, ...)
}
\arguments{
\item{x}{an `eigenmap-class` object.}

\item{...}{Further parameters to be passed to other functions or methods
(currently ignored).}
}
\description{
Create and handle spatial eigenvector maps of a set of locations a space with
an arbitrary number of dimensions.
}
\details{
The `print` method provides the number of the number of orthonormal
variables (i.e. basis functions), the number of observations these functions
are spanning, and their associated eigenvalues.

The `plot` method provides a plot of the eigenvalues and offers the
possibility to plot the values of variables for 1- or 2-dimensional sets of
coordinates. \code{plot.eigenmap} opens the default graphical device driver,
i.e., \code{X11}, \code{windows}, or \code{quartz} and recurses through
variable with a left mouse click on the graphical window. A right mouse click
interrupts recursing on \code{X11} and \code{windows} (Mac OS X users should
hit \emph{Esc} on the \code{quartz} graphical device driver (Mac OS X users).
}
\section{Functions}{
\itemize{
\item \code{print(eigenmap)}: Print method for eigenmap-class objects

\item \code{plot(eigenmap)}: Plot method for eigenmap-class objects

}}
\references{
Borcard, D. and Legendre, P. 2002. All-scale spatial analysis of ecological
data by means of principal coordinates of neighbour matrices. Ecol. Model.
153: 51-68

Dray, S.; Legendre, P. and Peres-Neto, P. 2006. Spatial modelling: a
comprehensive framework for principal coordinate analysis of neighbor
matrices (PCNM). Ecol. Modelling 196: 483-493

Legendre, P. and Legendre, L. 2012. Numerical Ecology, 3rd English edition.
Elsevier Science B.V., Amsterdam, The Netherlands.
}
\seealso{
\code{\link{MCA}}
\code{\link{eigenmap}}
}
\author{
\packageAuthor{codep}
Maintainer: \packageMaintainer{codep}
}
