% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefplot.r
\name{coefplot.data.frame}
\alias{coefplot.data.frame}
\title{coefplot.data.frame}
\usage{
\method{coefplot}{data.frame}(model, title = "Coefficient Plot",
  xlab = "Value", ylab = "Coefficient", lwdInner = 1, lwdOuter = 0,
  pointSize = 3, color = "blue", cex = 0.8, textAngle = 0,
  numberAngle = 0, shape = 16, linetype = 1, outerCI = 2, innerCI = 1,
  multi = FALSE, zeroColor = "grey", zeroLWD = 1, zeroType = 2,
  numeric = FALSE, fillColor = "grey", alpha = 1/2, horizontal = FALSE,
  facet = FALSE, scales = "free", value = "Value",
  coefficient = "Coefficient", errorHeight = 0, dodgeHeight = 1, ...)
}
\arguments{
\item{model}{A data.frame like that built from coefplot(..., plot=FALSE)}

\item{title}{The name of the plot, if NULL then no name is given}

\item{xlab}{The x label}

\item{ylab}{The y label}

\item{lwdInner}{The thickness of the inner confidence interval}

\item{lwdOuter}{The thickness of the outer confidence interval}

\item{pointSize}{Size of coefficient point}

\item{color}{The color of the points and lines}

\item{cex}{The text size multiplier, currently not used}

\item{textAngle}{The angle for the coefficient labels, 0 is horizontal}

\item{numberAngle}{The angle for the value labels, 0 is horizontal}

\item{shape}{The shape of the points}

\item{linetype}{The linetype of the error bars}

\item{outerCI}{How wide the outer confidence interval should be, normally 2 standard deviations.  If 0, then there will be no outer confidence interval.}

\item{innerCI}{How wide the inner confidence interval should be, normally 1 standard deviation.  If 0, then there will be no inner confidence interval.}

\item{multi}{logical; If this is for \code{\link{multiplot}} then leave the colors as determined by the legend, if FALSE then make all colors the same}

\item{zeroColor}{The color of the line indicating 0}

\item{zeroLWD}{The thickness of the 0 line}

\item{zeroType}{The type of 0 line, 0 will mean no line}

\item{numeric}{logical; If true and factors has exactly one value, then it is displayed in a horizontal graph with continuous confidence bounds.}

\item{fillColor}{The color of the confidence bounds for a numeric factor}

\item{alpha}{The transparency level of the numeric factor's confidence bound}

\item{horizontal}{logical; If the plot should be displayed horizontally}

\item{facet}{logical; If the coefficients should be faceted by the variables, numeric coefficients (including the intercept) will be one facet}

\item{scales}{The way the axes should be treated in a faceted plot.  Can be c("fixed", "free", "free_x", "free_y")}

\item{value}{Name of variable for value metric}

\item{coefficient}{Name of variable for coefficient names}

\item{errorHeight}{Height of error bars}

\item{dodgeHeight}{Amount of vertical dodging}

\item{\dots}{Further Arguments}
}
\value{
a ggplot graph object
}
\description{
Dotplot for coefficients
}
\details{
A graphical display of the coefficients and standard errors from a fitted model, this function uses a data.frame as the input.
}
\examples{
data(diamonds)
head(diamonds)
model1 <- lm(price ~ carat + cut*color, data=diamonds)
model2 <- lm(price ~ carat*color, data=diamonds)
df1 <- coefplot(model1, plot=FALSE)
df2 <- coefplot(model2, plot=FALSE)
coefplot(df1)
coefplot(df2)

}
\author{
Jared P. Lander
}
