test_that("The translation related functions are performing as expected", {

  test1nt = 'CTATATTTAATCTTTGGTGCATGAGCAGGAATAGTGGGCACAGCCCTTAGCCTACTTATTCGTACAGAATTAAGCCAACCCGGGACACTTCTGGGGGATGATCAAATCTACAATGTTATTGTAACTGCTCACGCTTTTGTAATAATCTTTTTTATAGTTATACCCGTAATAATCGGCGGTTTCGGAAATTGATTAGTGCCTTTAATAATTGGTGCACCAGACATAGCTTTTCCTCGAATAAATAACATAAGTTTTTGACTATTGCCACCATCTCTTCTATTACTTTTAGCTTCTGCTGGCGTCGAAGCAGGGGCTGGAACCGGATGAACGGTCTACCCCCCTCTTGCAGGTAATATAGCCCATGCTGGCGCATCCGTGGATTTAGCCATCTTCTCACTCCATTTAGCCGGTATTTCCTCCATTTTAGCCTCTATTAACTTTATTACTACTATTATTAATATAAAACCGCCTGCAATTTCTCAATACCAAACCCCACTCTTTGTCTGATCCATCCTTGTAACCACTGTCCTTCTTCTACTTGCTCTCCCCGTCCTTGCCGCTGCAATTACAATACTCTTAACTGACCGTAATTTAAATACAACATTTTTTGACCCAGCGGGAGGAGGGGACCCCATTCTTTACCAACACTTA'
  test1aa0 = "LYLIFGAWAG?VGTALSLLIRTELSQPGTLLGDDQIYNVIVTAHAFV?IFF?V?PV?IGGFGNWLVPL?IGAPD?AFPR?NN?SFWLLPPSLLLLLASAGVEAGAGTGWTVYPPLAGN?AHAGASVDLAIFSLHLAGISSILASINFITTIIN??PPAISQYQTPLFVWSILVTTVLLLLALPVLAAAIT?LLTDRNLNTTFFDPAGGGDPILYQHL"
  expect_equal(censored_translation(test1nt), test1aa0)

  test2nt = "---accttatatatgttatttgccttctgatcagggcttttaggaacatcaataagactcctcatccgaatagaacttgctcgaccaggtgttttccttggtagagacactttatataatacaattgttactgcacatgcgtgccttataattttttttatagtaatacctataatgataggaggttttggtaattgaataattcctcttataatacacacgcccgacatggcttttccacgactaaacaatttaagattttgacttttagtcccatctcttttgctacttttctcctcttcaactttagaatcaggcgtaggcacaggatgaactgtttatcctccgctttcaaacgcatcatatcacccgggcccccctgttgatctcgctattttctccttacatgttgctggggcctcatcaattttggcatctcttaatttcattactaccgtcattaatatgcgtccaacccgcatttcttatgaaaacacccctctacttatctgatctattatcctcaccgcaattcttctagttttagccatccctgttcttgcaggaggaattaccatactcttaacagaccgaaaccttaataccactttttttgaccctgcaggtgggggggacccaatcctctttcaacacctt"
  test2aa0 = "-TLYMLFAFWSGLLGTS??LLIR?ELARPGVFLG?DTLYNTIVTAHACL?IFF?V?P?M?GGFGNW?IPL??HTPDMAFPRLNNL?FWLLVPSLLLLFSSSTLESGVGTGWTVYPPLSNASYHPGPPVDLAIFSLHVAGASSILASLNFITTVINMRPTRISYENTPLLIWSIILTAILLVLAIPVLAGGIT?LLTDRNLNTTFFDPAGGGDPILFQHL"
  expect_equal(censored_translation(test2nt), test2aa0)

  test3nt = "accttatatatgttatttgccttctgatcagggcttttaggaacatcaataagactcctcatccgaatagaacttgctcgaccaggtgttttccttggtagagacactttatataatacaattgttactgcacatgcgtgccttataattttttttatagtaatacctataatgataggaggttttggtaattgaataattcctcttataatacacacgcccgacatggcttttccacgactaaacaatttaagattttgacttttagtcccatctcttttgctacttttctcctcttcaactttagaatcaggcgtaggcacaggatgaactgtttatcctccgctttcaaacgcatcatatcacccgggcccccctgttgatctcgctattttctccttacatgttgctggggcctcatcaattttggcatctcttaatttcattactaccgtcattaatatgcgtccaacccgcatttcttatgaaaacacccctctacttatctgatctattatcctcaccgcaattcttctagttttagccatccctgttcttgcaggaggaattaccatactcttaacagaccgaaaccttaataccactttttttgaccctgcaggtgggggggacccaatcctctttcaacacctt"
  test3aa0 = "TLYMLFAFWSGLLGTS??LLIR?ELARPGVFLG?DTLYNTIVTAHACL?IFF?V?P?M?GGFGNW?IPL??HTPDMAFPRLNNL?FWLLVPSLLLLFSSSTLESGVGTGWTVYPPLSNASYHPGPPVDLAIFSLHVAGASSILASLNFITTVINMRPTRISYENTPLLIWSIILTAILLVLAIPVLAGGIT?LLTDRNLNTTFFDPAGGGDPILFQHL"
  expect_equal(censored_translation(test3nt), test3aa0)

  test4nt = "ancttatatatgttatttgccttctgatcagggcttttaggaacatcaataagactcctcatccgaatagaacttgctcgaccaggtgttttccttggtagagacactttatataatacaattgttactgcacatgcgtgccttataattttttttatagtaatacctataatgataggaggttttggtaattgaataattcctcttataatacacacgcccgacatggcttttccacgactaaacaatttaagattttgacttttagtcccatctcttttgctacttttctcctcttcaactttagaatcaggcgtaggcacaggatgaactgtttatcctccgctttcaaacgcatcatatcacccgggcccccctgttgatctcgctattttctccttacatgttgctggggcctcatcaattttggcatctcttaatttcattactaccgtcattaatatgcgtccaacccgcatttcttatgaaaacacccctctacttatctgatctattatcctcaccgcaattcttctagttttagccatccctgttcttgcaggaggaattaccatactcttaacagaccgaaaccttaataccactttttttgaccctgcaggtgggggggacccaatcctctttcaacacctt"
  test4aa0 = "-LYMLFAFWSGLLGTS??LLIR?ELARPGVFLG?DTLYNTIVTAHACL?IFF?V?P?M?GGFGNW?IPL??HTPDMAFPRLNNL?FWLLVPSLLLLFSSSTLESGVGTGWTVYPPLSNASYHPGPPVDLAIFSLHVAGASSILASLNFITTVINMRPTRISYENTPLLIWSIILTAILLVLAIPVLAGGIT?LLTDRNLNTTFFDPAGGGDPILFQHL"
  expect_equal(censored_translation(test4nt), test4aa0)

  #testing the translation table helper function
  #get the translation table for a given phylum-family.
  #if ambigious, 0 is returned, indicating it is safest to employ censored translation.
  expect_equal(which_trans_table("Entomobryidae"), 5)
  expect_equal(which_trans_table("Vespidae"), 5)
  expect_equal(which_trans_table("Rhagionidae"), 5)
  expect_equal(which_trans_table("Iguanidae"), 2)
  expect_equal(which_trans_table("echinoidea"), 9)
  expect_equal(which_trans_table("hemichordata"), 0)

  #check that a bad input produces a warning
  expect_warning(which_trans_table("NotPhylogentic"))

})

