% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_logistic_auc_unbalanced}
\alias{f_logistic_auc_unbalanced}
\title{AUC of Binomial GLM with Logit Link and Case Weights}
\usage{
f_logistic_auc_unbalanced(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the binary response variable.}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
Area Under the Curve
}
\description{
Fits a quasibinomial GLM model \code{y ~ x} with case weights when \code{y} is an unbalanced binary response with values 0 and 1 and \code{x} is numeric. It uses the function \code{\link[=case_weights]{case_weights()}} to weight 0s and 1s according to their frequency within \code{y}.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

f_logistic_auc_unbalanced(
  x = "growing_season_length", #predictor
  y = "vi_binary",             #binary response
  df = vi
)

}
