% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.colorDF}
\alias{print.colorDF}
\alias{print_colorDF}
\title{Print method for colorful data frames}
\usage{
\method{print}{colorDF}(x, ...)

print_colorDF(
  x,
  n = getOption("colorDF_n"),
  width = getOption("width"),
  row.names = TRUE,
  tibble_style = getOption("colorDF_tibble_style"),
  highlight = NULL,
  sep = getOption("colorDF_sep"),
  ...
)
}
\arguments{
\item{x}{a colorful data frame (object with class colorDF)}

\item{...}{further arguments are ignored}

\item{n}{Number of rows to show (default=20, use Inf to show all; this
value can be set with options("colorDF_n"))}

\item{width}{number of characters that the data frame should span on output}

\item{row.names}{if TRUE (default), row names will be shown on output}

\item{tibble_style}{whether to print with tibble style (overrides style setting)}

\item{highlight}{a logical vector indicating which rows to highlight}

\item{sep}{column separator string (overrides style setting)}
}
\description{
Print method for colorful data frames
}
\details{
print_colorDF is the exported function, print.colorDF is the S3 method.
}
\examples{
print(colorDF(mtcars))
print_colorDF(mtcars)
}
\seealso{
[df_style()] on how to modify colorful data frames
}
