% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcm.R
\name{rgcm}
\alias{rgcm}
\title{GCM test with pre-computed residuals}
\usage{
rgcm(
  rY,
  rX,
  alternative = "two.sided",
  type = c("quadratic", "max", "scalar"),
  ...
)
}
\arguments{
\item{rY}{Vector or matrix of response values.}

\item{rX}{Matrix or data.frame of covariates.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. Only applies if \code{type = "quadratic"} and \code{Y} and
\code{X} are one-dimensional.}

\item{type}{Type of test statistic, either \code{"quadratic"} (default) or
\code{"max"}. If \code{"max"} is specified, the p-value is computed
based on a bootstrap approximation of the null distribution with
\code{B} samples.}

\item{...}{Further arguments passed to \code{\link[coin]{independence_test}()}.}
}
\value{
Object of class '\code{gcm}' and '\code{htest}' with the following
components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{p.value}}{The p-value for the \code{hypothesis}}
\item{\code{parameter}}{In case X is multidimensional, this is the degrees of
    freedom used for the chi-squared test.}
\item{\code{hypothesis}}{String specifying the null hypothesis.}
\item{\code{null.value}}{String specifying the null hypothesis.}
\item{\code{method}}{The string \code{"Generalised covariance measure test"}.}
\item{\code{data.name}}{A character string giving the name(s) of the data.}
\item{\code{rY}}{Residuals for the Y on Z regression.}
\item{\code{rX}}{Residuals for the X on Z regression.}
}
\description{
GCM test with pre-computed residuals
}
