% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsc.R
\encoding{UTF-8}
\name{subsc}
\alias{subsc}
\title{Converts a string to UTF-8 subscript}
\usage{
subsc(x)
}
\arguments{
\item{x}{A string to be converted to subscript.}
}
\value{
The subscript version of the string passed to the function,
if one exists. Otherwise, a question mark will be returned.
}
\description{
The \code{subsc} function translates a normal character to a UTF-8
subscript character.  The function can be used to
generate subscripts for many common characters.  All
numeric characters and some lower case letters have UTF-8 subscripts.
There are no upper case subscript letters.
This function is useful
because it saves you from having to look up the subscript character
code, or copy and paste from the internet.  If a corresponding
subscript character code does not exist, a question mark
will be returned for that character.
}
\examples{
# Date string
paste0("December 5", subsc("th"))

# Chemistry
paste0("H", subsc("2"), "SO", subsc("4"))
}
\seealso{
The \code{\link{supsc}} function to get superscripts.
}
