\name{compareGroups-package}
\alias{compareGroups-package}
\alias{compareGroups-package}
\docType{package}


\title{
Descriptive analysis by groups
}


\description{
Create data summaries for quality control, extensive reports for exploring data, as well as publication-ready univariate or bivariate tables in several formats (plain text, HTML,LaTeX, PDF, Word or Excel. 
Display statistics (mean, median, frequencies, incidences, etc.).
Create figures to quickly visualise the distribution of your data (boxplots, barplots, normality-plots, etc.).
Perform the appropriate tests (t-test, Analysis of variance, Kruskal-Wallis, Fisher, log-rank, ...) depending on the nature of the described variable (normal, non-normal or qualitative). 
Summarize genetic data (Single Nucleotide Polymorphisms) data displaying Allele Frequencies and performing Hardy-Weinberg Equilibrium tests among other typical statistics and tests for these kind of data.
}


\details{
\tabular{ll}{
Package: \tab compareGroups\cr
Type: \tab Package\cr
Version: \tab 3.3\cr
Date: \tab 2017-08-17\cr
License: \tab GPL version 2 or newer\cr
LazyLoad: \tab yes\cr
}
Main functions: 
\code{\link{compareGroups}}, 
\code{\link{compareSNPs}}, 
\code{\link{createTable}}, 
\code{\link{missingTable}}, 
\code{\link{export2latex}},
\code{\link{export2html}}, 
\code{\link{export2csv}}, 
\code{\link{export2pdf}}, 
\code{\link{export2md}},
\code{\link{export2word}},
\code{\link{export2xls}},
\code{\link{report}}, 
\code{\link{radiograph}}, 
\code{\link{cGroupsGUI}}, 
\code{\link{cGroupsWUI}}     
}


\author{
Main functions: Isaac Subirana <isubirana<at>imim.es>, Joan Vila <jvila<at>imim.es>, H\'ector Sanz <hsrodenas<at>gmail.com>, Gavin Lucas <gavin.lucas<at>cleargenetics.com> and David Gim\'enez <dgimenez1<at>imim.es>\cr

Web User Interface: Isaac Subirana <isubirana<at>imim.es>, Judith Pe\~nafiel <jpenafiel<at>imim.es>, Gavin Lucas <gavin.lucas<at>cleargenetics.com> and David Gim\'enez <dgimenez1<at>imim.es> \cr

Maintainer: Isaac Subirana <isubirana<at>imim.es>
}

\references{
  Isaac Subirana, Hector Sanz, Joan Vila (2014). Building Bivariate Tables: The compareGroups Package for R. Journal of Statistical Software, 57(12), 1-16. URL \url{http://www.jstatsoft.org/v57/i12/}.
}
 
\keyword{package}
