% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wl_matrix.R
\name{get_wl_matrix}
\alias{get_wl_matrix}
\title{Converts win-loss dataframe to win-loss matrix}
\usage{
get_wl_matrix(df, ties = "remove")
}
\arguments{
\item{df}{A results or win-loss dataframe}

\item{ties}{How to handle ties, default is \code{ties="remove"}
Alternative is \code{ties="keep"}}
}
\value{
A win-loss matrix
}
\description{
Converts win-loss dataframe to win-loss matrix
}
\section{Further details}{

Input dataframes or matrices with only 2 columns are
considered to be winners in column 1 and losers in column 2.
If input dataframe has three columns, the third column
will be the result of the interaction between column 1
subject and column 2 subject. The result can be in
the "W/L/T" format or "1/0/0.5" format.
See \code{\link{get_wl_df}}: for further info.
}
\examples{
get_wl_matrix(randomtourney(8))
get_wl_matrix(randomtourney(15,pties=.15))
get_wl_matrix(randomtourney(15,pties=.15),ties="keep")
get_wl_matrix(el)
}

