% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indep_ci.R
\name{indep_ci}
\alias{indep_ci}
\title{Confidence Interval for the difference between two independent ICCs}
\usage{
indep_ci(data1, data2, conf_level = 0.95)
}
\arguments{
\item{data1}{A dataframe in wide format}

\item{data2}{A dataframe in wide format}

\item{conf_level}{The confidence level of the confidence interval; defaults to 0.95 (95\%).}
}
\value{
A list with 3 elements:

ICC of data1 (\code{$icc_1})

ICC of data2 (\code{$icc_2})

Confidence interval for the difference between the ICC of data1 and the ICC of data2 (\code{$confidenceIntervalDifference})

The confidence interval is a 1x2 dataframe with calls \code{$lowerBound} and \code{$upperBound} for the bounds of the interval
}
\description{
Confidence Interval for the difference between two independent ICCs
}
\details{
Used when a different set of subjects are tested in each dataframe. The wide format for the dataframe means that the subjects constitute the rows, and the multiple trials per subject constitute the columns of the dataframe.
}
\examples{
subject1_test1 <- c(46, 42, 43)
subject2_test1 <- c(34, 35, 34)
subject3_test1 <- c(51, 48, 54)
rater1Data <- data.frame(subject1_test1, subject2_test1, subject3_test1)

subject4_test2 <- c(26, 25, 28)
subject5_test2 <- c(43, 45, 45)
subject6_test2 <- c(30, 31, 31)
rater2Data <- data.frame(subject4_test2, subject5_test2, subject6_test2)

indep_ci(rater1Data, rater2Data)
indep_ci(rater1Data, rater2Data, conf_level = 0.90)

}
