% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{zlm.wfit}
\alias{zlm.wfit}
\title{Least-Squares Linear Fitting for Complex Variables}
\usage{
zlm.wfit(
  x,
  y,
  w = rep(1L, ifelse(is.vector(x), length(x), nrow(x))),
  offset = NULL,
  method = "qr",
  tol = 1e-07,
  singular.ok = TRUE,
  ...
)
}
\arguments{
\item{x}{a complex design matrix, \code{n} rows by \code{p} columns.}

\item{y}{a vector of observations/responses of length \code{n}, or a matrix with \code{n} rows.}

\item{w}{a vector of weights to be used in the fitting process. The sum of \code{w * r^2} is minimized, with \code{r} being the residuals. By default, \code{w} is a vector of length \code{n} with every element equal to 1, making this an unweighted fit.}

\item{offset}{optional. A complex vector of length n that will be subtracted from y prior to fitting.}

\item{method}{optional. a string that can be used to choose any method you would like. As long as it is "qr".}

\item{tol}{tolerance for the \link{qr} decomposition. Default is 1e-7.}

\item{singular.ok}{logical. If false, a singular model is an error.}

\item{...}{currently disregarded.}
}
\value{
a \code{\link{list}} with components (for \code{lm.fit} and \code{lm.wfit})
  \item{coefficients}{\code{p} vector}
  \item{residuals}{\code{n} vector or matrix}
  \item{fitted.values}{\code{n} vector or matrix}
  \item{effects}{\code{n} vector of orthogonal single-df
    effects.  The first \code{rank} of them correspond to non-aliased
    coefficients, and are named accordingly.}
  \item{weights}{\code{n} vector --- \emph{only} for the \code{*wfit*}
    functions.}
  \item{rank}{integer, giving the rank}
  \item{df.residual}{degrees of freedom of residuals}
  \item{qr}{the QR decomposition, see \code{\link{qr}}.}

  Fits without any columns or non-zero weights do not have the
  \code{effects} and \code{qr} components.

  \code{.lm.fit()} returns a subset of the above, the \code{qr} part
  unwrapped, plus a logical component \code{pivoted} indicating if the
  underlying QR algorithm did pivot.
}
\description{
The function eventually called by \code{\link[=lm]{lm()}}, \code{\link[=lm.fit]{lm.fit()}}, and/or \code{\link[=lm.wfit]{lm.wfit()}} if fed complex data.
Performs ordinary (least-squares) linear fitting on complex variable data.
Like \code{\link[stats:lmfit]{stats::lm.wfit()}}, which it is based off of, it uses qr decomposition
for the matrix algebra. Unlike \code{stats::lm.wfit()} it also handles un-weighted
regression, by setting the weights to 1 by default.
}
\examples{
set.seed(4242)
n <- 6
p <- 2
slop <- complex(real = 4.23, imaginary = 2.323)
slop2 = complex(real = 2.1, imaginary = -3.9)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
desmat <- matrix(c(complex(real = rnorm(n * p), imaginary = rnorm(n * p)), rep(1, n)), n, p + 1)
y = desmat \%*\% c(slop, slop2, interc) + e
lm.fit(desmat, y)
}
