% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doConcrete.R, R/getOutput.R
\name{doConcrete}
\alias{doConcrete}
\alias{print.ConcreteEst}
\alias{plot.ConcreteEst}
\alias{print.ConcreteOut}
\title{doConcrete}
\usage{
doConcrete(ConcreteArgs)

\method{print}{ConcreteEst}(x, ...)

\method{plot}{ConcreteEst}(x, convergence = FALSE, gweights = TRUE, ask = FALSE, ...)

\method{print}{ConcreteOut}(x, ...)
}
\arguments{
\item{ConcreteArgs}{"ConcreteArgs" object : output of formatArguments()}

\item{x}{a ConcreteOut object}

\item{...}{additional arguments to be passed into print methods}

\item{convergence}{logical: plot the PnEIC norms for each TMLE small update step}

\item{gweights}{logical: plot the densities of the intervention-related nuisance weights for each intervention}

\item{ask}{logical: whether or not to prompt for user input before displaying plots}
}
\value{
object with s3 class "ConcreteEst"
}
\description{
doConcrete
}
\section{Functions}{
\itemize{
\item \code{print(ConcreteEst)}: print.ConcreteEst print method for "ConcreteEst" class

\item \code{plot(ConcreteEst)}: plot.ConcreteEst plot method for "ConcreteEst" class

\item \code{print(ConcreteOut)}: print.ConcreteOut print method for "ConcreteOut" class

}}
\examples{
library(data.table)
library(concrete)

data <- as.data.table(survival::pbc)
data <- data[1:200, .SD, .SDcols = c("id", "time", "status", "trt", "age", "sex")]
data[, trt := sample(0:1, nrow(data), TRUE)]

# formatArguments() returns correctly formatted arguments for doConcrete()

concrete.args <- formatArguments(DataTable = data,
                                 EventTime = "time",
                                 EventType = "status",
                                 Treatment = "trt",
                                 ID = "id",
                                 TargetTime = 2500,
                                 TargetEvent = c(1, 2),
                                 Intervention = makeITT(),
                                 CVArg = list(V = 2))
                                 
# doConcrete() returns tmle (and g-formula plug-in) estimates of targeted risks
\donttest{concrete.est <- doConcrete(concrete.args)}
}
