% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_table.R
\name{curve_table}
\alias{curve_table}
\title{Produce Tables For concurve Functions}
\usage{
curve_table(data, levels, type = "c", format = "data.frame")
}
\arguments{
\item{data}{Dataframe from a concurve function to produce a table for}

\item{levels}{Levels of the consonance intervals or likelihood intervals that should be
included in the table.}

\item{type}{Indicates whether the table is for a consonance function or likelihood function.
The default is set to "c" for consonance and can be switched to "l" for likelihood.}

\item{format}{The format of the tables. The options include "data.frame" which is the
default, "tibble", "docx" (which creates a table for a word document), "pptx" (which
creates a table for powerpoint), "latex", (which creates a table for a TeX document), and
"image", which produces an image of the table.}
}
\description{
Produces publication-ready tables with relevant statistics of interest
for functions produced from the concurve package.
}
\examples{

library(concurve)

GroupA <- rnorm(500)
GroupB <- rnorm(500)

RandomData <- data.frame(GroupA, GroupB)

intervalsdf <- curve_mean(GroupA, GroupB, data = RandomData, method = "default")

(z <- curve_table(intervalsdf[[1]], format = "data.frame"))
(z <- curve_table(intervalsdf[[1]], format = "tibble"))
(z <- curve_table(intervalsdf[[1]], format = "latex"))
}
