\name{KM}
\alias{KM}

\title{Kaplan-Meier product-limit estimate of survival.}

\description{This function provides survival estimates using the product-limit Kaplan-Meier estimator.}

\usage{
KM(time, status, t)
}

\arguments{
  \item{time}{ Survival time of the process.}
  \item{status}{Censoring indicator of the survival time of the process; 0 if the survival time is censored and 1 otherwise. }
  \item{t}{ The time for obtaining survival estimates.}
}


\references{
E. Kaplan and P. Meier. Nonparametric estimation from incomplete observations. Journal of the
American Statistical Association, 53:457-481, 1958.
}

\author{Luis Meira-Machado and Marta Sestelo}


\seealso{\code{\link{PKM}}}

\examples{
data(colonCS)
obj <- with(colonCS, survCS(time1, event1, Stime, event, age = age))
obj0 <- obj$data
KM(time = obj0$Stime, status = obj0$event, t = 1095)
}

