% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisplit.R
\name{conformal.multidim.msplit}
\alias{conformal.multidim.msplit}
\title{Multi Split Conformal Prediction Regions with Multivariate Response}
\usage{
conformal.multidim.msplit(
  x,
  y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed_beta = FALSE,
  verbose = FALSE,
  training_size = NULL,
  score = "max",
  s_type = "st-dev",
  B = 100,
  lambda = 0,
  tau = 1 - (B + 1)/(2 * B)
)
}
\arguments{
\item{x}{The feature variables, a matrix nxp.}

\item{y}{The matrix of multivariate responses (dimension nxq)}

\item{x0}{The new points to evaluate, a matrix of dimension n0xp.}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: matrix of features,
and y: matrix of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{split}{Indices that define the data-split to be used (i.e., the indices
define the first half of the data-split, on which the model is trained).
Default is NULL, in which case the split is chosen randomly.}

\item{seed}{Integer to be passed to set.seed before defining the random
data-split to be used. Default is FALSE, which effectively sets no seed.
If both split and seed are passed, the former takes priority and the latter
is ignored.}

\item{randomized}{Should the randomized approach be used? Default is FALSE.}

\item{seed_beta}{The seed for the randomized version. Default is FALSE.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}

\item{training_size}{Split proportion between training and calibration set.
Default is 0.5.}

\item{score}{The chosen score for the split conformal function.}

\item{s_type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev","alpha-max". Default is "std-dev"}

\item{B}{Number of repetitions. Default is 100.}

\item{lambda}{Smoothing parameter. Default is 0.}

\item{tau}{It is a smoothing parameter:
tau=1-1/B  Bonferroni intersection method
tau=0 unadjusted intersection
Default is 1-(B+1)/(2*B).}
}
\value{
A list with the following components x0, lo, up. In particular lo and up
are matrices of dimension n0 x q.
}
\description{
Compute prediction intervals using Multi Split conformal inference with
multivariate response.
}
\details{
The work is an extension of the univariate approach to Multi Split
conformal inference to a multivariate context.

This function is based on the package \code{\link{future.apply}} to
 perform parallelization.
}
\examples{

n = 33
n0 = 2
p = 2
mu = rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
my_grid <- seq(from=0,to=1,length.out=2)
y = t(apply(x,1,function(u) u[1] + u[2]*cos(6*pi*my_grid)))
x0 = mvtnorm::rmvnorm(n0, mu)
fun=mean_multi()
#fun=lm_multi()

B=3

final.multi=conformal.multidim.msplit(x=x,y=y, x0=x0,
                                      fun$train.fun, fun$predict.fun,
                       alpha=0.1,
                       split=NULL, seed=FALSE, randomized=FALSE,seed_beta=FALSE,
                       verbose=FALSE, training_size=NULL,s_type="st-dev",B=B,lambda=0,
                       score="l2")



}
\references{
"Multi Split Conformal Prediction" by Solari, Djordjilovic (2021) <arXiv:2103
.00627> is the baseline for the univariate case.
}
