% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFunctions_1_0_2.r
\name{makeplot}
\alias{makeplot}
\title{Function to create balance plot for a specified diagnostic}
\usage{
makeplot(input, diagnostic, approach, metric = "SMD", censoring, scope,
  average.over = NULL, stratum = NULL, label.exposure = "A",
  label.covariate = "C", lbound = -1, ubound = 1, ratio = 2,
  text.axis.title = 8, text.axis.y = 6.5, text.axis.x = 6.5,
  text.strip.y = 10, text.strip.x = 10, point.size = 0.75,
  zeroline.size = 0.1, refline.size = 0.1, refline.limit.a = -0.25,
  refline.limit.b = 0.25, panel.spacing.size = 0.75,
  axis.title = NULL, label.width = 15, grouptype = "none",
  shapetype = NULL, colourtype = NULL, colour_palette = "Set1",
  legend.title = "", legend.position = "bottom", text.legend = NULL)
}
\arguments{
\item{input}{output from balance()}

\item{diagnostic}{diagnostic of interest e.g. 1, 2, or 3}

\item{approach}{adjustment method e.g. "none" or "weight" or "stratify"}

\item{metric}{scale e.g. "D" for mean difference, "SMD" for standardized mean difference}

\item{censoring}{use censoring indicators/weights e.g. "yes" or "no"}

\item{scope}{report the entire trellis e.g. "all", the diagonal e.g. "recent", or a summary e.g. "average"}

\item{average.over}{level of summary for average e.g. "values" or "history" or "time" or "distance"}

\item{stratum}{the propensity-score stratum to plot}

\item{label.exposure}{common label used for exposure axis in plot (default = "A")}

\item{label.covariate}{common label used for covariate axis in plot (default = "C")}

\item{lbound}{lower bound for mean difference or standardized mean difference (default = -1)}

\item{ubound}{upper bound for mean difference or standardized mean difference (default = 1)}

\item{ratio}{aspect ratio of plot (default = 2)}

\item{text.axis.title}{font size of axis title (default = 8)}

\item{text.axis.y}{font size of y-axis values (default = 6.5)}

\item{text.axis.x}{font size of x-axis values (default = 6.5)}

\item{text.strip.y}{font size of y-axis label (default = 10)}

\item{text.strip.x}{font size of x-axis label (default = 10)}

\item{point.size}{size of data points (default = 0.75)}

\item{zeroline.size}{width of the line plotted at mean difference = 0 or standardized mean difference = 0 (default = 0.1)}

\item{refline.size}{width of the lines plotted at the specified fraction of the mean difference or standardized mean difference (default = 0.1)}

\item{refline.limit.a}{position of the lower reference line, specified as a fraction of the mean difference or standardized mean difference (default = -0.25)}

\item{refline.limit.b}{position of the upper reference line, specified as a fraction of the mean difference or standardized mean difference (default = 0.25)}

\item{panel.spacing.size}{space between each panel in the plot (default = 0.75)}

\item{axis.title}{main title for plot (optional)}

\item{label.width}{width of labels in plot (default = 15)}

\item{grouptype}{the type of grouping variable "shape" or "colour"}

\item{shapetype}{the variable name to assign a shape scale, either "exposure" or "history"}

\item{colourtype}{the variable name to assign a color scale, either "exposure" or "history"}

\item{colour_palette}{the palette used for scale_brewer. "Set1" is the default. See documentation for scale_brewer for other options: https://ropensci.github.io/plotly/ggplot2/scale_brewer.html.}

\item{legend.title}{title for legend (optional)}

\item{legend.position}{position of legend (default = "bottom")}

\item{text.legend}{text to include in legend (optional)}
}
\value{
A plot object. The trellised format is automatically chosen
based on the format of the input dataframe, determined by \code{balance()}
or \code{apply.scope()}.
}
\description{
Function to create balance plot for a specified diagnostic
}
\examples{
# Simulate the output of balance()
E <- as.numeric(rep(1,15))
H <- as.character(c(rep("H",3), rep("H0",6), rep("H01",6)))
name.cov <- as.character(c("l","m","n","l","l","m","m","n","n",
                           "l","l","m","m","n","n"))
time.exposure <- as.numeric(c(rep(0,3), rep(1,6), rep(2,6)))
time.covariate <- as.numeric(c(0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1))
D <- as.numeric(rnorm(15, 0.008401823, 0.1229099))
SMD <- as.numeric(rnorm(15, 0.01233356, 0.2696507))
N <- as.numeric(c(27,24,9,18,25,16,26,6,9,18,17,16,17,6,6))
Nexp <- as.numeric(c(14,12,4,9,12,8,13,3,5,9,8,8,9,3,3))

mytable <- data.frame(E, H, name.cov, time.exposure,
                      time.covariate, D, SMD, N, Nexp)

# Run the balance() function
myplot <- makeplot (input=mytable,
                    diagnostic=1,
                    approach="none",
                    censoring="no",
                    scope="all",
                    metric="SMD"
                    )
}
