% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_plenary.R
\name{sen_plenary_result}
\alias{sen_plenary_result}
\title{Returns results from the plenary in the Federal Senate for a
specified date}
\usage{
sen_plenary_result(date = NULL, ascii = TRUE)
}
\arguments{
\item{date}{\code{character}. Format YYYYMMDD.}

\item{ascii}{\code{logical}. If \code{TRUE}, the default, strips Latin
characters from the results.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Returns results from the plenary in the Federal Senate for a
specified date.
}
\examples{
# get info for the 3rd of March 2016:
x <- sen_plenary_result(date = "20160303")
# Earlier periods may not have information:
\dontrun{
y <- sen_plenary_result(date = "19910105")
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
