% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.rtf.R
\name{write.rtf}
\alias{write.rtf}
\title{A function for writing Rich Text Format (rtf) files}
\usage{
write.rtf(tex, path, name, outputlocation = path)
}
\arguments{
\item{tex}{is the tex value returned by \code{read.latex}.}

\item{path}{is the path value returned by \code{read.latex}.}

\item{name}{is the name of the output Rich Text Format file.}

\item{outputlocation}{is the location where the Rich Text Format file is to be saved. The default location is the same as path.}
}
\value{
\code{write.rtf} returns a file in Rich Text Format (rtf).
}
\description{
\code{write.rtf} converts LaTeX files (with extension .tex) generated by R Sweave using package 'knitr' to Rich Text Format (RTF) files. 
Features include: 1) conversion of R syntax highlighting; 2) conversion of tables generated by \code{Hmisc::describe}, \code{Hmisc::summary}, and 
\code{Hmisc::latex}; 3) conversion of mathematical equations; 4) conversion of graphics; 5) conversion of itemize and enumerate; 6) conversion of references.
}
\details{
For files with graphics, dev must be set to 'png' in 'knitr' chunk options for \code{write.rtf} to run properly.
}
\examples{
##Example 1
#Read a sample LaTeX file
file<-'connect3-minimal.tex'
filepath<-paste(sub("examples/.*","\\\\1",
          system.file("examples","connect3-minimal.tex",package="connect3")),
          "examples", sep='')
obj<-read.latex(file, filepath)
obj

#Convert a LaTeX file to a Rich Text Format file
tex<-obj$tex
path<-obj$path
name<-'connect3-minimal'
outputlocation<-gsub('\\\\\\\\','/',tempdir())
write.rtf(tex,path,name,outputlocation)

##Example 2
## Step 1: Download an R Sweave file using 'knitr' from:
##         'https://github.com/yihui/knitr/blob/master/inst/examples/knitr-minimal.Rnw'
## Step 2: Save it as 'knitr-minimal.Rnw' in a folder such: 'C:/Users/Desktop/tmp'. 
##         Change r code chunck options 
##         "<<boring-plots, fig.width=4, fig.height=4, out.width='.4\\\\linewidth'>>=" 
##         to 
##         "<<boring-plots, fig.width=3, fig.height=3, out.width='.4\\\\linewidth', dev='png'>>=". 
## Step 3: Click Compile PDF in RStudio
## Step 4: Read 'knitr-minimal.tex' file in the folder using function read.latex
# file<-'knitr-minimal.tex'
# filepath<-'C:/Users/Desktop/tmp'
# obj<-read.latex(file, filepath)
# obj
## Step 5: Converts 'knitr-minimal.tex' file to 'knitr-minimal.rtf' file using function write.rtf
# tex<-obj$tex
# path<-obj$path
# name<-'knitr-minimal'
# write.rtf(tex,path,name,outputlocation)
}
\references{
Yihui Xie (2015). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.10.5.

Frank E Harrell Jr, with contributions from Charles Dupont and many others. (2014). Hmisc: Harrell Miscellaneous. R package version 3.14-4. http://CRAN.R-project.org/package=Hmisc
}
\seealso{
\code{\link{read.latex}}
}

