% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{set_run_as}
\alias{set_run_as}
\title{Set RunAs User}
\usage{
set_run_as(content, run_as, run_as_current_user = FALSE)
}
\arguments{
\item{content}{an R6 Content item}

\item{run_as}{The RunAs user to use for this content}

\item{run_as_current_user}{Whether to run this content as the viewer of the application}
}
\value{
a Content object, updated with new details
}
\description{
Set the \code{RunAs} user for a piece of content.
The \code{run_as_current_user} flag only does anything if:
}
\details{
\itemize{
\item PAM is the authentication method
\item \code{Applications.RunAsCurrentUser} is enabled on the server
}

Also worth noting that the \code{run_as} user must exist on the Posit Connect
server (as a linux user) and have appropriate group memberships, or you will
get a \verb{400: Bad Request}. Set to \code{NULL} to use the default RunAs user / unset
any current configuration.

To "read" the current RunAs user, use the \code{Content} object or \code{get_content()} function.
}
\seealso{
connectapi::content_update

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
