% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEmbeddings}
\alias{plotEmbeddings}
\title{Plot panel of specified embeddings}
\usage{
plotEmbeddings(
  embeddings,
  groups = NULL,
  colors = NULL,
  ncol = NULL,
  nrow = NULL,
  raster = FALSE,
  raster.dpi = 300,
  panel.size = NULL,
  adjust.func = NULL,
  title.size = 6,
  adj.list = NULL,
  subset = NULL,
  return.plotlist = FALSE,
  ...
)
}
\arguments{
\item{embeddings}{list of two-column matrices with (x, y) coordinates of the embeddings. Each mutrix must have cell names in rownames.}

\item{groups}{vector of cluster labels, names contain cell names (default=NULL)}

\item{colors}{vector of numbers, which must be shown with point colors, names contain cell names (default=NULL). This argument is ignored if groups are provided.}

\item{ncol}{number of columns in the panel (default=NULL)}

\item{nrow}{number of rows in the panel (default=NULL)}

\item{raster}{boolean whether layer with the points be rasterized (default=FALSE). Setting of this argument to TRUE is useful when you need to export a plot with large number of points}

\item{raster.dpi}{dpi of the rasterized plot. (default=300). Ignored if raster == FALSE.}

\item{panel.size}{vector with two numbers, which specified (width, height) of the panel in inches (default=NULL). Ignored if raster is FALSE.}

\item{adjust.func}{function to adjust plots before combining them to single panel (default=NULL). Can be used, for example, to provide color pallette of guides of the plots.}

\item{subset}{a subset of cells to show (vector of cell names) (default=NULL)}

\item{return.plotlist}{boolean Whether to return a list of ggplot objects instead of a combined plot (default=FALSE)}

\item{...}{
  Arguments passed on to \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel}}
  \describe{
    \item{\code{mapping}}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}
    \item{\code{data}}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}
    \item{\code{stat}}{The statistical transformation to use on the data for this
layer, as a string.}
    \item{\code{position}}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}
    \item{\code{parse}}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}
    \item{\code{box.padding}}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}
    \item{\code{label.padding}}{Amount of padding around label, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}
    \item{\code{point.padding}}{Amount of padding around labeled point, as unit or
number. Defaults to 0. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}
    \item{\code{label.r}}{Radius of rounded corners, as unit or number. Defaults
to 0.15. (Default unit is lines, but other units can be specified by
passing \code{unit(x, "units")}).}
    \item{\code{label.size}}{Size of label border, in mm.}
    \item{\code{min.segment.length}}{Skip drawing segments shorter than this, as unit or
number. Defaults to 0.5. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}
    \item{\code{arrow}}{specification for arrow heads, as created by \code{\link[grid]{arrow}}}
    \item{\code{force}}{Force of repulsion between overlapping text labels. Defaults
to 1.}
    \item{\code{force_pull}}{Force of attraction between a text label and its
corresponding data point. Defaults to 1.}
    \item{\code{max.time}}{Maximum number of seconds to try to resolve overlaps.
Defaults to 0.5.}
    \item{\code{max.iter}}{Maximum number of iterations to try to resolve overlaps.
Defaults to 10000.}
    \item{\code{max.overlaps}}{Exclude text labels that overlap too many things.
Defaults to 10.}
    \item{\code{nudge_x}}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}
    \item{\code{nudge_y}}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}
    \item{\code{xlim}}{Limits for the x and y axes. Text labels will be constrained
to these limits. By default, text labels are constrained to the entire plot
area.}
    \item{\code{ylim}}{Limits for the x and y axes. Text labels will be constrained
to these limits. By default, text labels are constrained to the entire plot
area.}
    \item{\code{na.rm}}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}
    \item{\code{direction}}{"both", "x", or "y" -- direction in which to adjust position of labels}
    \item{\code{seed}}{Random seed passed to \code{\link[base]{set.seed}}. Defaults to
\code{NA}, which means that \code{set.seed} will not be called.}
    \item{\code{verbose}}{If \code{TRUE}, some diagnostics of the repel algorithm are printed}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
  }}
}
\value{
ggplot2 object with the panel of plots
}
\description{
Plot panel of specified embeddings
}
\keyword{internal}
