% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_authorization.R
\name{ms_fetch_key}
\alias{ms_fetch_key}
\alias{ms_exist_key}
\alias{ms_set_key}
\alias{ms_valid_key}
\title{Find API Key for Microsoft Cognitive Services Text To Speech (TTS)}
\usage{
ms_fetch_key(api_key = NULL, error = TRUE)

ms_exist_key(api_key = NULL)

ms_set_key(api_key)

ms_valid_key(api_key = NULL, region = "westus")
}
\arguments{
\item{api_key}{Microsoft Cognitive Services API key}

\item{error}{Should the function error if \code{api_key = NULL}?}

\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}
}
\value{
API key

Logical vector, indicating whether user has API key.

Logical vector, indicating whether API key is valid.
}
\description{
Determines if \code{option(ms_tts_key)} is set or key is stored in an
environment variable (MS_TTS_API_KEY, MS_TTS_API_KEY1, MS_TTS_API_KEY2). If
not found, stops and returns an error. If found, returns the value.
}
\section{Functions}{
\itemize{
\item \code{ms_exist_key()}: Does user have API key?

\item \code{ms_set_key()}: Set API Key as a global option

\item \code{ms_valid_key()}: Check whether API key is valid

}}
\note{
You can either set the API key using \code{option(ms_tts_key)} or have
it accessible by \code{api_key = Sys.getenv('MS_TTS_API_KEY")}, or
\code{api_key = Sys.getenv('MS_TTS_API_KEY1")}, or \code{api_key =
  Sys.getenv('MS_TTS_API_KEY2")}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
res = ms_fetch_key(api_key = NULL, error = FALSE)
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Don't provide api key but fetch it programmatically
ms_exist_key(api_key = NULL)

# Provide api key XXX
ms_exist_key(api_key = "XXX")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set api key XXX
ms_set_key(api_key = "XXX")
\dontshow{\}) # examplesIf}
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check whether API key is valid in westus
ms_valid_key(region = "westus")
\dontshow{\}) # examplesIf}
}
