% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactDur.area.R
\name{contactDur.area}
\alias{contactDur.area}
\title{Identify Environmental Contacts}
\usage{
contactDur.area(
  x,
  dist.threshold = 1,
  sec.threshold = 10,
  blocking = FALSE,
  blockLength = 1,
  blockUnit = "hours",
  blockingStartTime = NULL,
  equidistant.time = FALSE,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2),
  reportParameters = TRUE
)
}
\arguments{
\item{x}{Output from the dist2Area function (either df or sf variant). Can 
be either a data frame or non-data-frame list.}

\item{dist.threshold}{Numeric. Radial distance (in meters) within which 
"contact" can be said to occur. Defaults to 1. Note: If you are defining 
conttacts as occurring when polygons intersect, set dist.threshold to 0.}

\item{sec.threshold}{Numeric. Dictates the maximum amount of time between 
concurrent observations during which potential "contact" events remain 
unbroken. Defaults to 10.}

\item{blocking}{Logical. If TRUE, contacts will be evaluated for temporal 
blocks spanning blockLength blockUnit (e.g., 6 hours) within the data 
set. Defaults to FALSE.}

\item{blockLength}{Integer. Describes the number blockUnits within each 
temporal block. Defaults to 1.}

\item{blockUnit}{Character string taking the values, "secs," "mins," 
"hours," "days," or "weeks." Describes the temporal unit associated with 
each block. Defaults to "hours."}

\item{blockingStartTime}{Character string or date object describing the date
OR dateTime starting point of the first time block. For example, if 
blockingStartTime = "2016-05-01" OR "2016-05-01 00:00:00", the first 
timeblock would begin at "2016-05-01 00:00:00." If NULL, the 
blockingStartTime defaults to the minimum dateTime point in x. Note: 
any blockingStartTime MUST precede or be equivalent to the minimum 
timepoint in x. Additional note: If blockingStartTime is a character 
string, it must be in the format ymd OR ymd hms.}

\item{equidistant.time}{Logical. If TRUE, location fixes in individuals' 
movement paths are temporally equidistant (e.g., all fix intervals are 30
seconds). Defaults to FALSE. Note: This is a time-saving argument. A 
sub-function here calculates the time difference (dt) between each 
location fix. If all fix intervals are identical, it saves a lot of time.}

\item{parallel}{Logical. If TRUE, sub-functions within the contactDur.all 
wrapper will be parallelized. Defaults to FALSE.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}

\item{reportParameters}{Logical. If TRUE, function argument values will be 
appended to output data frame(s). Defaults to TRUE.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{indiv.id}{The unique ID of an individual observed in contact 
   with a specified fixed point/polygon.}
   \item{area.id}{The unique ID of a fixed point/polygon observed in contact
   with \code{indiv.id}.}
   \item{contact.id}{The unique ID used to identify contacts between the 
   \code{indiv.id} and \code{contact.id} pair.}    
   \item{contactDuration}{The number of sequential timepoints in \code{x} 
   that \code{indiv.id} and \code{area.id} were observed to be in 
   contact.}
   \item{contactStartTime}{The timepoint in \code{x} at which contact
   between \code{indiv.id} and \code{area.id} begins.}
   \item{contactEndTime}{The timepoint in \code{x} at which contact
   between \code{indiv.id} and \code{area.id} ends.}
   
   If blocking == TRUE, the following columns are appended to the output
   data frame described above:
   
   \item{block}{Integer ID describing unique blocks of time during which 
   contacts occur.}
   \item{block.start}{The timepoint in \code{x} at which the \code{block}
   begins.}
   \item{block.end}{The timepoint in \code{x} at which the \code{block}
   ends.}
   \item{numBlocks}{Integer describing the total number of time blocks 
   observed within \code{x} at which the \code{block}}
    
   Finally, if reportParameters == TRUE function arguments 
   \code{distThreshold}, \code{secThreshold}, \code{equidistant.time},
   and \code{blockLength} (if applicable) will be appended to the 
   output data frame.
}
\description{
This function uses the output from dist2Area to determine when tracked 
   individuals are in "contact" with fixed locations. Individuals are said 
   to be in a "contact" event (h) if they are observed within a given 
   distance (<= dist.threshold) at a given timestep(i). Sec.threshold 
   dictates the maximum amount of time a single, potential "contact" event 
   should exist. For example, if sec.threshold=10, only "contacts" occurring
   within 10secs of one another will be regarded as a single "contact" event
   of duration sum(h). If in this case, a time difference between contacts 
   was 11 seconds, the function will report two separate contact events.
   
The output of this function is a data frame containing a time-ordered 
   contact edge set detailing animal-environment contacts.
}
\examples{
data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date, 
  time = calves$time) #create a dataframe with dateTime identifiers for location fixes.

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag, 
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x, 
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE, 
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE, 
   na.rm = TRUE, smooth.type = 1) #smooth to 5-min fix intervals.

water<- data.frame(x = c(61.43315, 61.89377, 62.37518, 61.82622),
                  y = c(62.44815, 62.73341, 61.93864, 61.67411)) 

water_poly<-data.frame(matrix(ncol = 8, nrow = 1)) #(ncol = number of vertices)*2 #arrange data
colnum = 0
for(h in 1:nrow(water)){
 water_poly[1,colnum + h] <- water$x[h] #pull the x location for each vertex
 water_poly[1, (colnum + 1 + h)] <- water$y[h] #pull the y location for each vertex
 colnum <- colnum + 1
}

water_dist<-dist2Area_df(x = calves.agg, y = water_poly, 
  x.id = calves.agg$id, y.id = "water", dateTime = "dateTime", point.x = calves.agg$x, 
  point.y = calves.agg$y, poly.xy = NULL, parallel = FALSE, dataType = "Point", 
  lonlat = FALSE, numVertices = NULL) #find distances to the water trough 

water_contacts <- contactDur.area(water_dist, dist.threshold=1,
  sec.threshold=10, blocking = FALSE, blockUnit = "mins", blockLength = 10,
  equidistant.time = FALSE, parallel = FALSE, reportParameters = TRUE)
  
}
\keyword{contact}
\keyword{data-processing}
