% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict-S3.R
\name{dictS3replace}
\alias{dictS3replace}
\alias{[[<-.Dict}
\alias{[<-.Dict}
\alias{[[.Dict}
\alias{[.Dict}
\title{Extract or replace \code{Dict} values}
\usage{
\method{[[}{Dict}(dic, key, add = FALSE) <- value

\method{[}{Dict}(dic, key) <- value

\method{[[}{Dict}(dic, key)

\method{[}{Dict}(dic, key, default = NULL)
}
\arguments{
\item{dic}{\code{\link[container]{Dict}} object}

\item{key}{(character) the key}

\item{add}{(logical) if TRUE, value is added if not yet in dict. If FALSE
and value not yet in dict, an error is signaled.}

\item{value}{the value associated with the \code{key}}

\item{default}{the default value}
}
\value{
updated \code{\link[container]{Dict}} object

value at key

element found at key, or \code{default} if not found.
}
\description{
Access and assignment operators for \code{Dict} objects.
}
\details{
\code{dic[key] <- value}: If \code{key} not yet in \code{dic}, insert
 \code{value} at \code{key}, otherwise raise an error.

\code{dic[key]}: If \code{key} in \code{dic}, return value, else
 throw key-error.

\code{dic[key, default=NULL]}: Return the value for \code{key} if
 \code{key} is in \code{dic}, else \code{default}.
}
