## ----knitr-setup, include = FALSE-----------------------------------------------------------------
require(container)
knitr::opts_chunk$set(
  comment = "#",
    error = FALSE,
     tidy = FALSE,
    cache = FALSE,
 collapse = TRUE
)
old <- options(width = 100L)

## -------------------------------------------------------------------------------------------------
co <- container()
co[["x"]] <- 1
co <- c(co, 2)
co

## -------------------------------------------------------------------------------------------------
co = add(co, x = 3)  # same as c(co, container(x = 3))
co

## -------------------------------------------------------------------------------------------------
co[["x"]] <- 0
co[[2]] <- 12
co

## ---- error = TRUE--------------------------------------------------------------------------------
co[[4]] <- 4

## -------------------------------------------------------------------------------------------------
co[["y"]] <- 4
co

## -------------------------------------------------------------------------------------------------
replace_at(co, x = 10, y = 13)            # name = value pairs
replace_at(co, c("x", "y"),  c(10, 13))   # names followed by values
replace_at(co, c(1, 4),      c(10, 13))   # positions followed by values
replace_at(co, list(1, "y"), c(10, 13))   # mixed names/positions followed by values

## ---- error = TRUE--------------------------------------------------------------------------------
replace_at(co, z = 10)
replace_at(co, "z", 10)
replace_at(co, 5, 10)

## ---- error = TRUE--------------------------------------------------------------------------------
co = replace_at(co, z = 10, .add = TRUE)
co = replace_at(co, 7, 10, .add = TRUE)
co

## -------------------------------------------------------------------------------------------------
co = replace(co, 12, "foo")
co
co = replace(co, 4, 1:4)
co

## -------------------------------------------------------------------------------------------------
co[[{1:4}]] <- 1:2
co

## -------------------------------------------------------------------------------------------------
co[[1]]
co[["x"]]
co[3:5]
co[c("x", "y", "z")]

## -------------------------------------------------------------------------------------------------
at2(co, 1)
at2(co, "x")
at(co, 3:5)
at(co, c("x", "y", "z"))

## -------------------------------------------------------------------------------------------------
indices = list("x", 4, "z")
at(co, indices)

## ---- error = TRUE--------------------------------------------------------------------------------
at2(co, 10)
at2(co, "a")
at(co, 3:6)
at(co, c("x", "a"))

## -------------------------------------------------------------------------------------------------
l = list()
l[["a"]]
l[2:3]

## -------------------------------------------------------------------------------------------------
peek_at2(co, "a")
peek_at(co, 10, 11)
peek_at(co, 5:10)

## -------------------------------------------------------------------------------------------------
peek_at2(co, "a", default = -1)

peek_at(co, "z", "a", .default = -1)
peek_at(co, 4:8, .default = NA)

## -------------------------------------------------------------------------------------------------
l = list(a = 1)
l
l[["a"]] <- NULL
l

## -------------------------------------------------------------------------------------------------
co[["x"]] <- NULL
co

## -------------------------------------------------------------------------------------------------
delete_at(co, 1, "y", "z")
delete(co, NULL, 1:2, 10)   # same but remove by value

## ---- error = TRUE--------------------------------------------------------------------------------
delete_at(co, "a")
delete_at(co, 10)

delete(co, 1:3)

## -------------------------------------------------------------------------------------------------
discard_at(co, 1, "a")
discard_at(co, 1:100)

discard(co, NULL, 1:2, 1:3, 1:4)

## -------------------------------------------------------------------------------------------------
c1 = container(1, b = 2)
c2 = container(   b = 0, c = 3)

update(c1, c2)
update(c2, c1)

## -------------------------------------------------------------------------------------------------
l1 = list(1, b = 2)
l2 = list(   b = 0, c = 3)

update(l1, l2)
update(l2, l1)

## ---- include = FALSE---------------------------------------------------------
options(old)

