% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Adjusted_inv_sinh_CI_OR_2x2.R
\name{Adjusted_inv_sinh_CI_OR_2x2}
\alias{Adjusted_inv_sinh_CI_OR_2x2}
\title{The adjusted inverse hyperbolic sine confidence interval for the odds ratio}
\usage{
Adjusted_inv_sinh_CI_OR_2x2(
  n,
  psi1 = 0.45,
  psi2 = 0.25,
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{psi1}{pseudo-frequency (should be > 0)}

\item{psi2}{pseudo-frequency (should be > 0)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The adjusted inverse hyperbolic sine confidence interval for the odds ratio.

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# A case-control study of GADA exposure on IPEX syndrome (Lampasona et al., 2013)
n <- matrix(c(9,4,4,10), nrow=2, byrow=TRUE)
Adjusted_inv_sinh_CI_OR_2x2(n)
# The association between CHRNA4 genotype and XFS (Ritland et al., 2007)
n <- matrix(c(0,16,15,57), nrow=2, byrow=TRUE)
Adjusted_inv_sinh_CI_OR_2x2(n)
}
