% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_estimates_and_CIs_stratified_2x2.R
\name{ML_estimates_and_CIs_stratified_2x2}
\alias{ML_estimates_and_CIs_stratified_2x2}
\title{Maximum likelihood estimates with CIs of the grouping and strata effects}
\usage{
ML_estimates_and_CIs_stratified_2x2(
  n,
  link = "log",
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}

\item{link}{the link function ('linear', 'log', or 'logit')}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the maximum likelihood estimates
}
\description{
Maximum likelihood estimates with CIs of the grouping and strata effects

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
n <- array(dim = c(2, 2, 2))
n[, , 1] <- matrix(c(647, 622, 2, 27), 2, byrow = TRUE)
n[, , 2] <- matrix(c(41, 28, 19, 32), 2, byrow = TRUE)
ML_estimates_and_CIs_stratified_2x2(n)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
n <- array(0, dim = c(2, 2, 6))
n[, , 1] <- rbind(c(2, 37), c(1, 42))
n[, , 2] <- rbind(c(4, 40), c(4, 40))
n[, , 3] <- rbind(c(6, 101), c(4, 106))
n[, , 4] <- rbind(c(7, 96), c(5, 95))
n[, , 5] <- rbind(c(7, 103), c(3, 103))
n[, , 6] <- rbind(c(11, 143), c(4, 142))
ML_estimates_and_CIs_stratified_2x2(n)

}
