% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_pattern_ori.R
\name{ms_pattern_ori}
\alias{ms_pattern_ori}
\title{Find patterns for all countries}
\usage{
ms_pattern_ori(myTB, timeName = "time", typeIn = c("highBest", "lowBest")[1])
}
\arguments{
\item{myTB}{a dataset (tibble) for an indicator, time by countries.
The first and last time are respectively the first
and last rows of the dataset,
which must be  time sorted.}

\item{timeName}{a string with name of the time variable}

\item{typeIn}{the type of indicator considered 'highBest' (default)
or 'lowBest'}
}
\value{
the type of pattern
}
\description{
The input is a time by countries dataset where all countries contributing
to the average must be present.
Indicators of type 'low is better' are transformed
(highestRef - Y), thus the distance from the maximum value
for each original observation is calculated.
}
\details{
This is the reference implementation as described  by the Eurofound  report
"Monitoring convergence in the European Union
Upward convergence in the EU: Concepts, measurements and indicators", 2018.
}
\examples{

# Example 1
# Dataset in the format time by countries:
require(tibble)
testTB <- dplyr::tribble(
   ~time, ~countryA ,  ~countryB,  ~countryC,
   2000,     0.8,   2.7,    3.9,
   2001,     1.2,   3.2,    4.2,
   2002,     0.9,   2.9,    4.1,
   2003,     1.3,   2.9,    4.0,
   2004,     1.2,   3.1,    4.1,
   2005,     1.2,   3.0,    4.0
   )
resT1 <- ms_pattern_ori(testTB,"time","lowBest")
resT2 <- ms_pattern_ori(testTB,"time","highBest")

# Example 2
# Patterns for the emp_20_64_MS Eurofound dataset:
data("emp_20_64_MS")

# Patterns according to the 'highBetter' indicator:
resPATThigh <-ms_pattern_ori(emp_20_64_MS, "time")

# Patterns according to the 'lowBetter' indicator:
resPATTlow <-ms_pattern_ori(emp_20_64_MS, "time","lowBest")



}
\references{
{\url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
