% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyfgtdec.R
\name{svyfgtdec}
\alias{svyfgtdec}
\alias{svyfgtdec.survey.design}
\alias{svyfgtdec.svyrep.design}
\alias{svyfgtdec.DBIsvydesign}
\title{FGT indices decomposition (EXPERIMENTAL)}
\usage{
svyfgtdec(formula, design, ...)

\method{svyfgtdec}{survey.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svyfgtdec}{svyrep.design}(
  formula,
  design,
  g,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svyfgtdec}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{additional arguments. Currently not used.}

\item{g}{If g=2 estimates the average squared normalised poverty gap. This function is defined for g >= 2 only,}

\item{type_thresh}{type of poverty threshold. If "abs" the threshold is fixed and given the value
of abs_thresh; if "relq" it is given by percent times the quantile; if "relm" it is percent times the mean.}

\item{abs_thresh}{poverty threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the the quantile or mean used in the poverty threshold definition}

\item{quantiles}{the quantile used used in the poverty threshold definition}

\item{na.rm}{Should cases with missing values be dropped?}

\item{thresh}{return the poverty threshold value}
}
\value{
Object of class "\code{cvydstat}", with estimates for the FGT(g), FGT(0), FGT(1), income gap ratio and GEI(income gaps; epsilon = g) with a "\code{var}" attribute giving the variance-covariance matrix.
A "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Foster et al. (1984) poverty class and its components
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# absolute poverty threshold
svyfgtdec(~eqincome, des_eusilc, g=2, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, des_eusilc, g=2, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, des_eusilc, g=2, type_thresh= "relm" , thresh = TRUE)

# using svrep.design:
# absolute poverty threshold
svyfgtdec(~eqincome, des_eusilc_rep, g=2, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, des_eusilc_rep, g=2, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, des_eusilc_rep, g=2, type_thresh= "relm" , thresh = TRUE)

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )


# absolute poverty threshold
svyfgtdec(~eqincome, dbd_eusilc, g=2, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, dbd_eusilc, g=2, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, dbd_eusilc, g=2, type_thresh= "relm" , thresh = TRUE)

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Oihana Aristondo, Cassilda Lasso De La vega and Ana Urrutia (2010).
A new multiplicative decomposition for the Foster-Greer-Thorbecke poverty indices.
\emph{Bulletin of Economic Research}, Vol.62, No.3, pp. 259-267.
University of Wisconsin. <doi:10.1111/j.1467-8586.2009.00320.x>

James Foster, Joel Greer and Erik Thorbecke (1984). A class of decomposable poverty measures.
\emph{Econometrica}, Vol.52, No.3, pp. 761-766.

Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{https://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X19990024882}.
}
\seealso{
\code{\link{svyfgt},\link{svyfgt},\link{svyfgt}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
