% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapleyValue.R
\name{shapleyValue}
\alias{shapleyValue}
\title{Shapley Value Solution}
\usage{
shapleyValue(game, show.data = FALSE)
}
\arguments{
\item{game}{a vector that represents the cooperative game.}

\item{show.data}{logical value indicating if the function displays the 
console output (\code{TRUE}) or not (\code{FALSE}). By default the 
value is \code{FALSE}.}
}
\value{
\code{shapleyValue} returns and prints the Shapley Value
of associated cooperative game.
}
\description{
Calculates the Shapley Value for a N-agent cooperative game.
}
\examples{
# Cooperative game
game <- c(68, 102, 0, 170, 710, 762, 992)
# Shapley Value
shapleyValue(game, show.data = TRUE)

 # -----------------------------
 # Shapley Value Solution: 
 # -----------------------------
 # [1] "(229, 272, 491)"
  
}
\author{
D. Prieto
}
