% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cops.R
\name{cop_sstress}
\alias{cop_sstress}
\title{PCOPS version of sstress}
\usage{
cop_sstress(
  dis,
  theta = c(2, 1, 1),
  weightmat = 1 - diag(nrow(dis)),
  init = NULL,
  ndim = 2,
  itmaxi = 10000,
  ...,
  stressweight = 1,
  cordweight = 0.5,
  q = 1,
  minpts = ndim + 1,
  epsilon = 10,
  rang = NULL,
  verbose = 0,
  scale = "sd",
  normed = TRUE,
  stresstype = c("default", "stress1", "rawstress", "normstress", "enormstress",
    "enormstress1")
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this is either a scalar of the lambda transformation for the observed proximities, or a vector where the first is the kappa argument for the fitted distances (here internally fixed to 2) and the second the lambda argument and the third the nu argument (internally fixed to 1). Defaults to 2 1 1}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{init}{(optional) initial configuration}

\item{ndim}{number of dimensions of the target space}

\item{itmaxi}{number of iterations. default is 10000.}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.5}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the distances (min distance minus max distance). If NULL (default) the cordillera will be normed to each configuration's maximum distance, so an absolute value of goodness-of-clusteredness.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{scale}{should the configuration be scale adjusted}

\item{normed}{should the cordillera be normed; defaults to TRUE}

\item{stresstype}{which stress to report? Defaults to explicitly normed stress}
}
\value{
A list with the components
\itemize{
        \item stress: the stress
        \item stress.m: default normalized stress
        \item copstress: the weighted loss value
        \item OC: the Optics cordillera value
        \item parameters: the parameters used for fitting (kappa, lambda)
        \item fit: the returned object of the fitting procedure
        \item cordillera: the cordillera object
}
}
\description{
PCOPS version of sstress
}
\keyword{multivariate}
