% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_methods.r
\name{tCorpus$context}
\alias{tCorpus$context}
\alias{context}
\title{Get a context vector}
\arguments{
\item{context_level}{Select whether the context is document or sentence level}

\item{with_labels}{Return context as only ids (numeric, starting at 1) or with labels (factor)}
}
\description{
Depending on the purpose, the context of an analysis can be the document level or sentence level. the tCorpus$context() method offers a convenient way to get the context id of tokens for different settings.
}
\section{Usage}{

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{data(context_level = c('document','sentence'), with_labels = T)}
}

\examples{
tc <- create_tcorpus(c('Text one first sentence. Text one second sentence', 'Text two'),
                     split_sentences = TRUE)

doc <- tc$context() ## default context is doc_id (document level)
doc

sent <- tc$context('sentence') ## can specify sentence level
sent
}
