% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_text.r
\name{browse_texts}
\alias{browse_texts}
\title{Create and view a full text browser}
\usage{
browse_texts(tc, doc_ids = NULL, token_col = "token", n = 500,
  select = c("first", "random"), header = "", subheader = NULL,
  highlight = NULL, scale = NULL, category = NULL,
  meta_cols = NULL, seed = NA, nav = NULL, top_nav = NULL,
  thres_nav = 1, view = T, highlight_col = "yellow",
  scale_col = c("red", "blue", "green"), filename = NULL)
}
\arguments{
\item{tc}{a tCorpus}

\item{doc_ids}{A vector with document ids to view}

\item{token_col}{The name of the column in tc$tokens that contain the token text}

\item{n}{Only n of the results are printed (to prevent accidentally making huge browsers).}

\item{select}{If n is smaller than the number of documents in tc, select determines how the n documents are selected}

\item{header}{Optionally, a title presented at the top of the browser}

\item{subheader}{Optionally, overwrite the subheader. By default the subheader reports the number of documents}

\item{highlight}{The name of a numeric column in tc$tokens with values between 0 and 1, used to highlight tokens.
Can also be a character vector, in which case al non-NA values are highlighted}

\item{scale}{The name of a numeric column in tc$tokens with values between -1 and 1, used to color tokens on a scale (set colors with scale_col)}

\item{category}{The name of a character or factor column in tc$tokens. Each unique value will have its own color, and navigation for categories will be added (nav cannot be used with this option)}

\item{meta_cols}{A character vector with names of columns in tc$meta, used to only show the selected columns}

\item{seed}{If select is "random", seed can be used to set a random seed. After sampling the seed is re-initialized with set.seed(NULL).}

\item{nav}{Optionally, a column in tc$meta to add navigation (only supports simple filtering on unique values).
This is not possible if annotate is used.}

\item{top_nav}{A number. If navigation based on token annotations is used, filters will only apply to top x values with highest token occurence in a document}

\item{thres_nav}{Like top_nav, but specifying a threshold for the minimum number of tokens.}

\item{view}{If TRUE (default), view the browser in the Viewer window (turn off if this is not supported)}

\item{highlight_col}{If highlight is used, the color for highlighting}

\item{scale_col}{If scale is used, a vector with 2 or more colors used to create a color ramp. That is, -1 is first color, +1 is last color, if three colors are given 0 matches the middle color, and colors in between are interpolated.}

\item{filename}{Optionally, save the browser at a specified location}
}
\value{
The url for the file location is returned (invisibly)
}
\description{
Creates a static HTML file to view the texts in the tcorpus in full text mode.
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_column='id')
url = browse_texts(tc)


## tokens can be highlighted, scaled or coloured for different categories
## to validate analyses such as dictionaries, scaling and topic modeling
tc = create_tcorpus(sotu_texts, doc_column = 'id', udpipe_model='english-ewt')
tc$preprocess('lemma', 'feature', min_docfreq = 10)
tc$feature_subset('feature', POS \%in\% c('NOUN','PROPN','VERB'))
m = tc$lda_fit('feature', create_feature = 'topic', K = 5, alpha = 0.001)

browse_texts(tc, category='topic', view=T, top_nav=1)
}
}
