% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_to_ci.R, R/cor_to_p.R
\name{cor_to_ci}
\alias{cor_to_ci}
\alias{cor_to_p}
\title{Convert correlation to p-values and CIs}
\usage{
cor_to_ci(cor, n, ci = 0.95, method = "pearson", correction = "fieller", ...)

cor_to_p(cor, n, method = "pearson")
}
\arguments{
\item{cor}{A correlation matrix or coefficient.}

\item{n}{The sample size (number of observations).}

\item{ci}{Confidence/Credible Interval level. If \code{"default"}, then it is
set to 0.95 (95\% CI).}

\item{method}{A character string indicating which correlation coefficient is
to be used for the test. One of \code{"pearson"} (default),
\code{"kendall"}, \code{"spearman"}, \code{"biserial"},
\code{"polychoric"}, \code{"tetrachoric"}, \code{"biweight"},
\code{"distance"}, \code{"percentage"} (for percentage bend correlation),
\code{"blomqvist"} (for Blomqvist's coefficient), \code{"hoeffding"} (for
Hoeffding's D), \code{"gamma"}, \code{"gaussian"} (for Gaussian Rank
correlation) or \code{"shepherd"} (for Shepherd's Pi correlation). Setting
\code{"auto"} will attempt at selecting the most relevant method
(polychoric when ordinal factors involved, tetrachoric when dichotomous
factors involved, point-biserial if one dichotomous and one continuous and
pearson otherwise).}

\item{correction}{Only used if method is 'spearman' or 'kendall'. Can be
'fieller' (default; Fieller et al., 1957), 'bw' (only for Spearman) or
'none'. Bonett and Wright (2000) claim their correction ('bw') performs
better, though the Bishara and Hittner (2017) paper favours the Fieller
correction. Both are generally very similar.}

\item{...}{Additional arguments (e.g., \code{alternative}) to be passed to
other methods. See \code{stats::cor.test} for further details.}
}
\value{
A list containing a p-value and the statistic or the CI bounds.
}
\description{
Get statistics, p-values and confidence intervals (CI) from correlation coefficients.
}
\examples{
cor.test(iris$Sepal.Length, iris$Sepal.Width)
cor_to_p(-0.1175698, n = 150)
cor_to_p(cor(iris[1:4]), n = 150)
cor_to_ci(-0.1175698, n = 150)
cor_to_ci(cor(iris[1:4]), n = 150)

cor.test(iris$Sepal.Length, iris$Sepal.Width, method = "spearman")
cor_to_p(-0.1667777, n = 150, method = "spearman")
cor_to_ci(-0.1667777, ci = 0.95, n = 150)

cor.test(iris$Sepal.Length, iris$Sepal.Width, method = "kendall")
cor_to_p(-0.07699679, n = 150, method = "kendall")
}
\references{
Bishara, A. J., & Hittner, J. B. (2017). Confidence intervals for
  correlations when data are not normal. Behavior research methods, 49(1),
  294-309.
}
