% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhatIfRegr.R
\name{WhatIfRegr}
\alias{WhatIfRegr}
\title{WhatIf for Regression Tasks}
\description{
WhatIf returns the \code{n_counterfactual} most similar observations to \code{x_interest} from observations in \code{predictor$data$X}
whose prediction is in the \code{desired_outcome} interval.
}
\details{
Only observations whose features values lie between the corresponding values in \code{lower} and \code{upper} are considered
counterfactual candidates.
}
\examples{
if (require("randomForest")) {
  set.seed(123456)
  # Train a model
  rf = randomForest(mpg ~ ., data = mtcars)
  # Create a predictor object
  predictor = iml::Predictor$new(rf)
  # Find counterfactuals for x_interest
  wi_regr = WhatIfRegr$new(predictor, n_counterfactuals = 5L)
  cfactuals = wi_regr$find_counterfactuals(
    x_interest = mtcars[1L, ], desired_outcome = c(22, 26)
  )
  # Print the results
  cfactuals
}

}
\references{
Gower, J. C. (1971), "A general coefficient of similarity and some of its properties". Biometrics, 27, 623–637.

Wexler, J., Pushkarna, M., Bolukbasi, T., Wattenberg, M., Viégas, F., & Wilson, J. (2019). The what-if tool:
Interactive probing of machine learning models. IEEE transactions on visualization and computer graphics, 26(1), 56–65.
}
\section{Super classes}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{\link[counterfactuals:CounterfactualMethodRegr]{counterfactuals::CounterfactualMethodRegr}} -> \code{WhatIfRegr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WhatIfRegr-new}{\code{WhatIfRegr$new()}}
\item \href{#method-WhatIfRegr-clone}{\code{WhatIfRegr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethodRegr" data-id="find_counterfactuals"><a href='../../counterfactuals/html/CounterfactualMethodRegr.html#method-CounterfactualMethodRegr-find_counterfactuals'><code>counterfactuals::CounterfactualMethodRegr$find_counterfactuals()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WhatIfRegr-new"></a>}}
\if{latex}{\out{\hypertarget{method-WhatIfRegr-new}{}}}
\subsection{Method \code{new()}}{
Create a new WhatIfRegr object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WhatIfRegr$new(
  predictor,
  n_counterfactuals = 1L,
  lower = NULL,
  upper = NULL,
  distance_function = "gower"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{n_counterfactuals}}{(\code{integerish(1)})\cr
The number of counterfactuals to return Default is \code{1L}.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\verb{function()} | \code{'gower'} | \code{'gower_c'})\cr
The distance function used to compute the distances between \code{x_interest}
and the training data points for finding \code{x_nn}.
Either the name of an already implemented distance function
('gower' or 'gower_c') or a function.
If set to 'gower' (default), then Gower's distance (Gower 1971) is used;
if set to 'gower_c', a C-based more efficient version of Gower's distance is used.
A function must have three arguments  \code{x}, \code{y}, and \code{data} and should
return a \code{double} matrix with \code{nrow(x)} rows and maximum \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WhatIfRegr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WhatIfRegr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WhatIfRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
