% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.countgmifs.R
\name{summary.countgmifs}
\alias{summary.countgmifs}
\title{Summarize a Count GMIFS Object.}
\usage{
\method{summary}{countgmifs}(object, model.select = "BIC", ...)
}
\arguments{
\item{object}{an \code{countgmifs} fitted object.}

\item{model.select}{when \code{x} is specified any model along the solution path can be selected. The default is \code{model.select="BIC"} which calculates the predicted values using the coefficients from the model having the lowest BIC. Other options are \code{model.select="AIC"} or any numeric value from the solution path.}

\item{...}{other arguments.}
}
\description{
Prints the following items extracted from the fitted \code{countgmifs} object: the family used and model parameter estimates. For models that include \code{x}, the parameter estimates, AIC, BIC, and log-likelihood are printed for indicated \code{model.select} step or if \code{model.select} is not supplied the step at which the minimum BIC was observed.
}
\seealso{
See Also \code{\link{countgmifs}}, \code{\link{coef.countgmifs}}, \code{\link{predict.countgmifs}}, \code{\link{plot.countgmifs}}
}
\keyword{methods}
